/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class OffsetCommitResponse
extends AbstractResponse {
    private final OffsetCommitResponseData data;

    public OffsetCommitResponse(OffsetCommitResponseData data) {
        super(ApiKeys.OFFSET_COMMIT);
        this.data = data;
    }

    public OffsetCommitResponse(int requestThrottleMs, Map<TopicPartition, Errors> responseData) {
        super(ApiKeys.OFFSET_COMMIT);
        HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic> responseTopicDataMap = new HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic>();
        for (Map.Entry<TopicPartition, Errors> entry : responseData.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            OffsetCommitResponseData.OffsetCommitResponseTopic topic = responseTopicDataMap.getOrDefault(topicName, new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicName));
            topic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition()));
            responseTopicDataMap.put(topicName, topic);
        }
        this.data = new OffsetCommitResponseData().setTopics(new ArrayList<OffsetCommitResponseData.OffsetCommitResponseTopic>(responseTopicDataMap.values())).setThrottleTimeMs(requestThrottleMs);
    }

    public OffsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        this(0, responseData);
    }

    @Override
    public OffsetCommitResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return OffsetCommitResponse.errorCounts(this.data.topics().stream().flatMap(topicResult -> topicResult.partitions().stream().map(partitionResult -> Errors.forCode(partitionResult.errorCode()))));
    }

    public static OffsetCommitResponse parse(Readable readable, short version, MessageContext context) {
        return new OffsetCommitResponse(new OffsetCommitResponseData(readable, version, context));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }

    public static boolean useTopicIds(short version) {
        return version >= 10;
    }

    public static Builder newBuilder(boolean useTopicIds) {
        if (useTopicIds) {
            return new TopicIdBuilder();
        }
        return new TopicNameBuilder();
    }

    public static class TopicIdBuilder
    extends Builder {
        private final HashMap<Uuid, OffsetCommitResponseData.OffsetCommitResponseTopic> byTopicId = new HashMap();

        @Override
        protected void add(OffsetCommitResponseData.OffsetCommitResponseTopic topic) {
            TopicIdBuilder.throwIfTopicIdIsNull(topic.topicId());
            this.data.topics().add(topic);
            this.byTopicId.put(topic.topicId(), topic);
        }

        @Override
        protected OffsetCommitResponseData.OffsetCommitResponseTopic get(Uuid topicId, String topicName) {
            TopicIdBuilder.throwIfTopicIdIsNull(topicId);
            return this.byTopicId.get(topicId);
        }

        @Override
        protected OffsetCommitResponseData.OffsetCommitResponseTopic getOrCreate(Uuid topicId, String topicName) {
            TopicIdBuilder.throwIfTopicIdIsNull(topicId);
            OffsetCommitResponseData.OffsetCommitResponseTopic topic = this.byTopicId.get(topicId);
            if (topic == null) {
                topic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicName).setTopicId(topicId);
                this.data.topics().add(topic);
                this.byTopicId.put(topicId, topic);
            }
            return topic;
        }

        private static void throwIfTopicIdIsNull(Uuid topicId) {
            if (topicId == null) {
                throw new IllegalArgumentException("TopicId cannot be null.");
            }
        }
    }

    public static class TopicNameBuilder
    extends Builder {
        private final HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic> byTopicName = new HashMap();

        @Override
        protected void add(OffsetCommitResponseData.OffsetCommitResponseTopic topic) {
            this.throwIfTopicNameIsNull(topic.name());
            this.data.topics().add(topic);
            this.byTopicName.put(topic.name(), topic);
        }

        @Override
        protected OffsetCommitResponseData.OffsetCommitResponseTopic get(Uuid topicId, String topicName) {
            this.throwIfTopicNameIsNull(topicName);
            return this.byTopicName.get(topicName);
        }

        @Override
        protected OffsetCommitResponseData.OffsetCommitResponseTopic getOrCreate(Uuid topicId, String topicName) {
            this.throwIfTopicNameIsNull(topicName);
            OffsetCommitResponseData.OffsetCommitResponseTopic topic = this.byTopicName.get(topicName);
            if (topic == null) {
                topic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicName).setTopicId(topicId);
                this.data.topics().add(topic);
                this.byTopicName.put(topicName, topic);
            }
            return topic;
        }

        private void throwIfTopicNameIsNull(String topicName) {
            if (topicName == null) {
                throw new IllegalArgumentException("TopicName cannot be null.");
            }
        }
    }

    public static abstract class Builder {
        protected OffsetCommitResponseData data = new OffsetCommitResponseData();

        protected abstract void add(OffsetCommitResponseData.OffsetCommitResponseTopic var1);

        protected abstract OffsetCommitResponseData.OffsetCommitResponseTopic get(Uuid var1, String var2);

        protected abstract OffsetCommitResponseData.OffsetCommitResponseTopic getOrCreate(Uuid var1, String var2);

        public Builder addPartition(Uuid topicId, String topicName, int partitionIndex, Errors error) {
            OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = this.getOrCreate(topicId, topicName);
            topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partitionIndex).setErrorCode(error.code()));
            return this;
        }

        public <P> Builder addPartitions(Uuid topicId, String topicName, List<P> partitions, Function<P, Integer> partitionIndex, Errors error) {
            OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = this.getOrCreate(topicId, topicName);
            partitions.forEach(partition -> topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex((Integer)partitionIndex.apply(partition)).setErrorCode(error.code())));
            return this;
        }

        public Builder merge(OffsetCommitResponseData newData) {
            if (this.data.topics().isEmpty()) {
                this.data = newData;
            } else {
                newData.topics().forEach(newTopic -> {
                    OffsetCommitResponseData.OffsetCommitResponseTopic existingTopic = this.get(newTopic.topicId(), newTopic.name());
                    if (existingTopic == null) {
                        this.add((OffsetCommitResponseData.OffsetCommitResponseTopic)newTopic);
                    } else {
                        existingTopic.partitions().addAll(newTopic.partitions());
                    }
                });
            }
            return this;
        }

        public OffsetCommitResponse build() {
            return new OffsetCommitResponse(this.data);
        }
    }
}

