/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.PushTelemetryResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class PushTelemetryResponse
extends AbstractResponse {
    private final PushTelemetryResponseData data;

    public PushTelemetryResponse(PushTelemetryResponseData data) {
        super(ApiKeys.PUSH_TELEMETRY);
        this.data = data;
    }

    @Override
    public PushTelemetryResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        PushTelemetryResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public static PushTelemetryResponse parse(Readable readable, short version, MessageContext context) {
        return new PushTelemetryResponse(new PushTelemetryResponseData(readable, version, context));
    }
}

