/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Map;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class RenewDelegationTokenResponse
extends AbstractResponse {
    private final RenewDelegationTokenResponseData data;

    public RenewDelegationTokenResponse(RenewDelegationTokenResponseData data) {
        super(ApiKeys.RENEW_DELEGATION_TOKEN);
        this.data = data;
    }

    public static RenewDelegationTokenResponse parse(Readable readable, short version, MessageContext context) {
        return new RenewDelegationTokenResponse(new RenewDelegationTokenResponseData(readable, version, context));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return RenewDelegationTokenResponse.errorCounts(this.error());
    }

    @Override
    public RenewDelegationTokenResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public long expiryTimestamp() {
        return this.data.expiryTimestampMs();
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

