/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.ResolveOffsetRangeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ResolveOffsetRangeResponse
extends AbstractResponse {
    public static final int UNKNOWN_OFFSET = -1;
    private final ResolveOffsetRangeResponseData data;

    public ResolveOffsetRangeResponse(ResolveOffsetRangeResponseData data) {
        super(ApiKeys.RESOLVE_OFFSET_RANGE);
        this.data = data;
    }

    public List<ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse> topics() {
        return this.data.topics();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.topics().forEach(topic -> topic.partitions().forEach(partition -> ResolveOffsetRangeResponse.updateErrorCounts(errorCounts, Errors.forCode(partition.errorCode()))));
        return errorCounts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public ResolveOffsetRangeResponseData data() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static ResolveOffsetRangeResponse parse(Readable readable, short version, MessageContext context) {
        return new ResolveOffsetRangeResponse(new ResolveOffsetRangeResponseData(readable, version, context));
    }
}

