/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.utils.Exit;
import org.slf4j.Logger;

public class DefaultUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final AtomicBoolean EXIT_ON_OOM_ENABLED = new AtomicBoolean(false);
    private final Logger log;

    public DefaultUncaughtExceptionHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof OutOfMemoryError && EXIT_ON_OOM_ENABLED.get()) {
            this.log.error("OutOfMemoryError in thread {}, aborting the process.", (Object)t.getName(), (Object)e);
            Exit.halt(1);
        } else {
            this.log.error("Uncaught exception in thread '{}':", (Object)t.getName(), (Object)e);
        }
    }

    public static void enableExitOnOutOfMemoryError(boolean enabled) {
        EXIT_ON_OOM_ENABLED.set(enabled);
    }
}

