/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.authorizer;

import java.net.InetAddress;
import java.util.Optional;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public interface AuthorizableRequestContext {
    public String listenerName();

    public SecurityProtocol securityProtocol();

    public KafkaPrincipal principal();

    public InetAddress clientAddress();

    default public String clientAddressAsString() {
        return this.clientAddress().toString();
    }

    public boolean isProxyModeLocal();

    public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2();

    public int requestType();

    public int requestVersion();

    public String clientId();

    public int correlationId();

    default public long kafkaRequestId() {
        return -1L;
    }

    default public long sessionId() {
        return -1L;
    }

    default public Optional<String> tenantPrefix() {
        return Optional.empty();
    }
}

