/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.DefaultDirProvider;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionChangeBuilder {
    private static final Logger log = LoggerFactory.getLogger(PartitionChangeBuilder.class);
    private final PartitionRegistration partition;
    private final Uuid topicId;
    private final int partitionId;
    private final IntPredicate isAcceptableLeader;
    private final MetadataVersion metadataVersion;
    private final Map<Integer, Set<DegradedBrokerHealthState>> activeBrokerComponentDegradations;
    private final int minISR;
    private final Map<Integer, Uuid> targetDirectories;
    private List<Integer> targetIsr;
    private List<Integer> targetReplicas;
    private List<Integer> targetObservers;
    private List<Integer> targetRemoving;
    private List<Integer> targetAdding;
    private List<Integer> targetRemovingObservers;
    private List<Integer> targetAddingObservers;
    private Election election = Election.ONLINE;
    private LeaderRecoveryState targetLeaderRecoveryState;
    private int linkedLeaderEpoch;
    private PartitionRegistration.LinkState linkState;
    private List<Integer> targetElr;
    private List<Integer> targetLastKnownElr;
    private List<Integer> uncleanShutdownReplicas;
    private boolean eligibleLeaderReplicasEnabled;
    private DefaultDirProvider defaultDirProvider;
    private boolean preferredInternalTopic;
    private boolean useLastKnownLeaderInBalancedRecovery = true;

    public static boolean changeRecordIsNoOp(PartitionChangeRecord record, PartitionRegistration.LinkState priorLinkState) {
        if (record.isr() != null) {
            return false;
        }
        if (record.eligibleLeaderReplicas() != null) {
            return false;
        }
        if (record.lastKnownElr() != null) {
            return false;
        }
        if (record.leader() != -2) {
            return false;
        }
        if (record.replicas() != null) {
            return false;
        }
        if (record.observers() != null) {
            return false;
        }
        if (record.removingReplicas() != null) {
            return false;
        }
        if (record.addingReplicas() != null) {
            return false;
        }
        if (record.removingObservers() != null) {
            return false;
        }
        if (record.addingObservers() != null) {
            return false;
        }
        if (record.leaderRecoveryState() != -1) {
            return false;
        }
        if (record.linkedLeaderEpoch() != -1) {
            return false;
        }
        if (priorLinkState.levelCode != record.linkState()) {
            return false;
        }
        return record.directories() == null;
    }

    public PartitionChangeBuilder(PartitionRegistration partition, Uuid topicId, String topicName, int partitionId, IntPredicate isAcceptableLeader, MetadataVersion metadataVersion, Map<Integer, Set<DegradedBrokerHealthState>> activeBrokerComponentDegradations, int minISR) {
        this.partition = partition;
        this.topicId = topicId;
        this.partitionId = partitionId;
        this.isAcceptableLeader = isAcceptableLeader;
        this.metadataVersion = metadataVersion;
        this.activeBrokerComponentDegradations = activeBrokerComponentDegradations;
        this.eligibleLeaderReplicasEnabled = false;
        this.minISR = minISR;
        this.targetIsr = Replicas.toList(partition.isr);
        this.targetReplicas = Replicas.toList(partition.replicas);
        this.targetObservers = Replicas.toList(partition.observers);
        this.targetRemoving = Replicas.toList(partition.removingReplicas);
        this.targetAdding = Replicas.toList(partition.addingReplicas);
        this.targetRemovingObservers = Replicas.toList(partition.removingObservers);
        this.targetAddingObservers = Replicas.toList(partition.addingObservers);
        this.targetElr = Replicas.toList(partition.elr);
        this.targetLastKnownElr = Replicas.toList(partition.lastKnownElr);
        this.targetLeaderRecoveryState = partition.leaderRecoveryState;
        this.linkedLeaderEpoch = partition.linkedLeaderEpoch;
        this.linkState = partition.linkState;
        this.targetDirectories = DirectoryId.createAssignmentMap((int[])partition.replicas, (Uuid[])partition.directories);
        this.defaultDirProvider = uuid -> {
            throw new IllegalStateException("DefaultDirProvider is not set");
        };
        this.preferredInternalTopic = Topic.isExternalConnectivityStartupTopic((String)topicName);
    }

    public PartitionChangeBuilder setTargetIsr(List<Integer> targetIsr) {
        this.targetIsr = targetIsr;
        return this;
    }

    public PartitionChangeBuilder setTargetIsrWithBrokerStates(List<AlterPartitionRequestData.BrokerState> targetIsrWithEpoch) {
        return this.setTargetIsr(targetIsrWithEpoch.stream().map(AlterPartitionRequestData.BrokerState::brokerId).collect(Collectors.toList()));
    }

    public PartitionChangeBuilder setTargetReplicas(List<Integer> targetReplicas) {
        this.targetReplicas = targetReplicas;
        return this;
    }

    public PartitionChangeBuilder setTargetObservers(List<Integer> targetObservers) {
        this.targetObservers = targetObservers;
        return this;
    }

    public PartitionChangeBuilder setUncleanShutdownReplicas(List<Integer> uncleanShutdownReplicas) {
        this.uncleanShutdownReplicas = uncleanShutdownReplicas;
        return this;
    }

    public PartitionChangeBuilder setElection(Election election) {
        this.election = election;
        return this;
    }

    public PartitionChangeBuilder setTargetRemoving(List<Integer> targetRemoving) {
        this.targetRemoving = targetRemoving;
        return this;
    }

    public PartitionChangeBuilder setTargetAdding(List<Integer> targetAdding) {
        this.targetAdding = targetAdding;
        return this;
    }

    public PartitionChangeBuilder setTargetRemovingObservers(List<Integer> targetRemovingObservers) {
        this.targetRemovingObservers = targetRemovingObservers;
        return this;
    }

    public PartitionChangeBuilder setTargetAddingObservers(List<Integer> targetAddingObservers) {
        this.targetAddingObservers = targetAddingObservers;
        return this;
    }

    public PartitionChangeBuilder setTargetLeaderRecoveryState(LeaderRecoveryState targetLeaderRecoveryState) {
        this.targetLeaderRecoveryState = targetLeaderRecoveryState;
        return this;
    }

    public PartitionChangeBuilder setLinkedLeaderEpoch(int linkedLeaderEpoch) {
        this.linkedLeaderEpoch = linkedLeaderEpoch;
        return this;
    }

    public PartitionChangeBuilder setLinkFailed(boolean linkFailed) {
        if (linkFailed) {
            return this.setLinkState(PartitionRegistration.LinkState.FAILED);
        }
        return this.setLinkState(PartitionRegistration.LinkState.ACTIVE);
    }

    public PartitionChangeBuilder setLinkState(PartitionRegistration.LinkState linkState) {
        this.linkState = linkState;
        return this;
    }

    public PartitionChangeBuilder setEligibleLeaderReplicasEnabled(boolean eligibleLeaderReplicasEnabled) {
        this.eligibleLeaderReplicasEnabled = eligibleLeaderReplicasEnabled;
        return this;
    }

    public PartitionChangeBuilder setUseLastKnownLeaderInBalancedRecovery(boolean useLastKnownLeaderInBalancedRecovery) {
        this.useLastKnownLeaderInBalancedRecovery = useLastKnownLeaderInBalancedRecovery;
        return this;
    }

    public PartitionChangeBuilder setDirectory(int brokerId, Uuid dir) {
        this.targetDirectories.put(brokerId, dir);
        return this;
    }

    public PartitionChangeBuilder setDefaultDirProvider(DefaultDirProvider defaultDirProvider) {
        this.defaultDirProvider = defaultDirProvider;
        return this;
    }

    public List<Integer> targetIsr() {
        return this.targetIsr;
    }

    ElectionResult electLeader(boolean completedReassignment) {
        Optional<ElectionResult> syncReplicaElectionResult;
        if (this.election == Election.PREFERRED) {
            return this.electPreferredLeader();
        }
        if (this.canAttemptToMoveLeadershipFromObserver(completedReassignment) && (syncReplicaElectionResult = this.electSyncReplica()).isPresent()) {
            return syncReplicaElectionResult.get();
        }
        return this.electAnyLeader();
    }

    protected boolean canAttemptToMoveLeadershipFromObserver(boolean completedReassignment) {
        if (completedReassignment && !this.targetObservers.isEmpty()) {
            return true;
        }
        if (this.isReassignmentInProgress() || this.targetObservers.isEmpty()) {
            return false;
        }
        ArrayList<Integer> syncReplicas = new ArrayList<Integer>(this.targetReplicas);
        syncReplicas.removeAll(this.targetObservers);
        boolean allSyncReplicasInIsr = this.targetIsr.containsAll(syncReplicas);
        return allSyncReplicasInIsr;
    }

    private boolean isReassignmentInProgress() {
        return PartitionReassignmentReplicas.isReassignmentInProgress(this.targetRemoving, this.targetAdding, this.targetRemovingObservers, this.targetAddingObservers);
    }

    public boolean degradedBrokersExist() {
        return this.activeBrokerComponentDegradations != null && !this.activeBrokerComponentDegradations.isEmpty();
    }

    private ElectionResult electPreferredLeader() {
        int preferredLeaderId = this.targetReplicas.get(0);
        if (this.isValidNewLeader(preferredLeaderId) && !this.isDegraded(preferredLeaderId)) {
            return new ElectionResult(preferredLeaderId, false);
        }
        int bestValidLeaderId = this.bestValidLeaderId();
        if (bestValidLeaderId != -1) {
            return new ElectionResult(bestValidLeaderId, false);
        }
        if (this.canElectLastKnownLeader()) {
            return new ElectionResult(this.partition.lastKnownElr[0], true);
        }
        return new ElectionResult(-1, false);
    }

    private int bestValidLeaderId() {
        if (this.isValidNewLeader(this.partition.leader) && !this.isDegraded(this.partition.leader)) {
            return this.partition.leader;
        }
        int bestValidLeaderId = -1;
        for (Integer replicaId : this.targetReplicas) {
            if (!this.isValidNewLeader(replicaId)) continue;
            if (bestValidLeaderId == -1) {
                bestValidLeaderId = replicaId;
            }
            if (this.isDegraded(replicaId)) continue;
            return replicaId;
        }
        return bestValidLeaderId;
    }

    private int bestUncleanLeaderId() {
        int bestUncleanLeaderId = -1;
        for (Integer replicaId : this.targetReplicas) {
            if (!this.isAcceptableLeader.test(replicaId)) continue;
            if (bestUncleanLeaderId == -1) {
                bestUncleanLeaderId = replicaId;
            }
            if (this.isDegraded(replicaId)) continue;
            return replicaId;
        }
        return bestUncleanLeaderId;
    }

    private ElectionResult electAnyLeader() {
        int bestValidLeaderId = this.bestValidLeaderId();
        if (bestValidLeaderId != -1) {
            return new ElectionResult(bestValidLeaderId, false);
        }
        int bestUncleanLeaderId = -1;
        if (this.canElectLastKnownLeader()) {
            bestUncleanLeaderId = this.partition.lastKnownElr[0];
        } else if (this.election == Election.UNCLEAN) {
            bestUncleanLeaderId = this.bestUncleanLeaderId();
        }
        return new ElectionResult(bestUncleanLeaderId, bestUncleanLeaderId != -1);
    }

    public boolean isDegraded(Integer brokerId) {
        if (this.degradedBrokersExist() && this.activeBrokerComponentDegradations.containsKey(brokerId)) {
            if (this.preferredInternalTopic) {
                return this.activeBrokerComponentDegradations.get(brokerId).stream().filter(state -> state.component() != BrokerComponent.EXTERNAL_CONNECTIVITY_STARTUP).count() > 0L;
            }
            return true;
        }
        return false;
    }

    private boolean canElectLastKnownLeader() {
        if (!this.eligibleLeaderReplicasEnabled || !this.useLastKnownLeaderInBalancedRecovery) {
            log.trace("Try to elect last known leader for {}-{} but elrEnabled={}, useLastKnownLeaderInBalancedRecovery={}", new Object[]{this.topicId, this.partitionId, this.eligibleLeaderReplicasEnabled, this.useLastKnownLeaderInBalancedRecovery});
            return false;
        }
        if (!this.targetElr.isEmpty() || !this.targetIsr.isEmpty()) {
            log.trace("Try to elect last known leader for {}-{} but ELR/ISR is not empty. ISR={}, ELR={}", new Object[]{this.topicId, this.partitionId, this.targetIsr, this.targetElr});
            return false;
        }
        if (this.partition.lastKnownElr.length != 1) {
            log.trace("Try to elect last known leader for {}-{} but lastKnownElr does not only have 1 member. lastKnownElr={}", new Object[]{this.topicId, this.partitionId, Arrays.toString(this.partition.lastKnownElr)});
            return false;
        }
        if (!this.isAcceptableLeader.test(this.partition.lastKnownElr[0])) {
            log.trace("Try to elect last known leader for {}-{} but last known leader is not alive. last known leader={}", new Object[]{this.topicId, this.partitionId, this.partition.lastKnownElr[0]});
            return false;
        }
        return true;
    }

    private boolean isValidNewLeader(int replica) {
        return (this.targetIsr.contains(replica) || this.targetIsr.isEmpty() && this.targetElr.contains(replica)) && this.isAcceptableLeader.test(replica);
    }

    private void tryElection(PartitionChangeRecord record, boolean completedReassignment) {
        ElectionResult electionResult = this.electLeader(completedReassignment);
        if (electionResult.node != this.partition.leader) {
            if (this.targetElr.contains(electionResult.node)) {
                this.targetIsr = List.of(Integer.valueOf(electionResult.node));
                this.targetElr = this.targetElr.stream().filter(replica -> replica != electionResult.node).collect(Collectors.toList());
                log.info("Setting new leader for topicId {}, partition {} to {} using ELR. Previous partition: {}, change record: {}", new Object[]{this.topicId, this.partitionId, electionResult.node, this.partition, record});
            } else if (electionResult.unclean) {
                log.info("Setting new leader for topicId {}, partition {} to {} using an unclean election. Previous partition: {}, change record: {}", new Object[]{this.topicId, this.partitionId, electionResult.node, this.partition, record});
            } else {
                log.trace("Setting new leader for topicId {}, partition {} to {} using a clean election", new Object[]{this.topicId, this.partitionId, electionResult.node});
            }
            record.setLeader(electionResult.node);
            if (electionResult.unclean) {
                record.setIsr(List.of(Integer.valueOf(electionResult.node)));
                if (this.partition.leaderRecoveryState != LeaderRecoveryState.RECOVERING) {
                    record.setLeaderRecoveryState(LeaderRecoveryState.RECOVERING.value());
                }
            }
        } else {
            log.trace("Failed to find a new leader with current state: {}", (Object)this);
        }
    }

    private Optional<ElectionResult> electSyncReplica() {
        if (!this.targetObservers.contains(this.partition.leader)) {
            return Optional.empty();
        }
        Optional<Integer> onlineLeader = this.findSyncLeader(replica -> this.isValidNewLeader((int)replica) && !this.isDegraded((Integer)replica));
        if (!onlineLeader.isPresent()) {
            onlineLeader = this.findSyncLeader(this::isValidNewLeader);
        }
        return onlineLeader.map(leader -> new ElectionResult((int)leader, false));
    }

    private Optional<Integer> findSyncLeader(Predicate<Integer> leaderPredicate) {
        return this.targetReplicas.stream().filter(replica -> !this.targetObservers.contains(replica)).filter(leaderPredicate).findFirst();
    }

    void triggerLeaderEpochBumpForReplicaReassignmentIfNeeded(PartitionChangeRecord record) {
        if (record.leader() != -2) {
            return;
        }
        if (!Replicas.contains(this.targetReplicas, this.partition.replicas)) {
            record.setLeader(this.partition.leader);
        }
    }

    void triggerLeaderEpochBumpForIsrShrinkIfNeeded(PartitionChangeRecord record) {
        if (!this.metadataVersion.isLeaderEpochBumpRequiredOnIsrShrink()) {
            return;
        }
        if (record.leader() != -2) {
            return;
        }
        if (record.isr() == null) {
            return;
        }
        if (!Replicas.contains(record.isr(), this.partition.isr)) {
            record.setLeader(this.partition.leader);
        }
    }

    private boolean completeReassignmentIfNeeded() {
        PartitionReassignmentReplicas reassignmentReplicas = new PartitionReassignmentReplicas(this.targetRemoving, this.targetAdding, this.targetReplicas, this.targetObservers, this.targetRemovingObservers, this.targetAddingObservers);
        Optional<PartitionReassignmentReplicas.CompletedReassignment> completedReassignmentOpt = reassignmentReplicas.maybeCompleteReassignment(this.targetIsr);
        if (completedReassignmentOpt.isEmpty()) {
            return false;
        }
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = completedReassignmentOpt.get();
        this.targetIsr = completedReassignment.isr;
        this.targetReplicas = completedReassignment.replicas;
        this.targetObservers = completedReassignment.observers;
        this.targetRemoving = List.of();
        this.targetAdding = List.of();
        this.targetRemovingObservers = List.of();
        this.targetAddingObservers = List.of();
        return true;
    }

    static boolean completedReassignment(PartitionChangeRecord change) {
        return change.removingReplicas() != null || change.addingReplicas() != null || change.removingObservers() != null || change.addingObservers() != null;
    }

    public Optional<ApiMessageAndVersion> build() {
        PartitionChangeRecord record = new PartitionChangeRecord().setTopicId(this.topicId).setPartitionId(this.partitionId);
        this.maybePopulateTargetElr();
        boolean completedReassignment = this.completeReassignmentIfNeeded();
        this.tryElection(record, completedReassignment);
        this.triggerLeaderEpochBumpForReplicaReassignmentIfNeeded(record);
        this.maybeUpdateRecordElr(record);
        if (!(record.isr() != null || this.targetIsr.isEmpty() && !this.eligibleLeaderReplicasEnabled || this.targetIsr.equals(Replicas.toList(this.partition.isr)))) {
            if (this.targetIsr.isEmpty()) {
                log.debug("A partition will have an empty ISR. {}", (Object)this);
            }
            record.setIsr(this.targetIsr);
        }
        this.triggerLeaderEpochBumpForIsrShrinkIfNeeded(record);
        this.maybeUpdateLastKnownLeader(record);
        this.setAssignmentChanges(record);
        if (this.targetLeaderRecoveryState != this.partition.leaderRecoveryState) {
            record.setLeaderRecoveryState(this.targetLeaderRecoveryState.value());
        }
        if (this.partition.isMirror()) {
            if (this.linkedLeaderEpoch != this.partition.linkedLeaderEpoch) {
                record.setLinkedLeaderEpoch(this.linkedLeaderEpoch);
            }
            record.setLinkState(this.linkState.levelCode);
        }
        if (PartitionChangeBuilder.changeRecordIsNoOp(record, this.partition.linkState)) {
            return Optional.empty();
        }
        return Optional.of(new ApiMessageAndVersion((ApiMessage)record, this.metadataVersion.partitionChangeRecordVersion()));
    }

    private void setAssignmentChanges(PartitionChangeRecord record) {
        if (!this.targetReplicas.isEmpty()) {
            if (this.metadataVersion.isDirectoryAssignmentSupported()) {
                ArrayList<Uuid> directories = new ArrayList<Uuid>(this.targetReplicas.size());
                for (int replica : this.targetReplicas) {
                    directories.add(this.targetDirectories.getOrDefault(replica, this.defaultDirProvider.defaultDir(replica)));
                }
                if (!directories.equals(Arrays.asList(this.partition.directories))) {
                    record.setDirectories(directories);
                }
            }
            if (!this.targetReplicas.equals(Replicas.toList(this.partition.replicas))) {
                record.setReplicas(this.targetReplicas);
            }
        }
        if (!this.targetObservers.equals(Replicas.toList(this.partition.observers))) {
            record.setObservers(this.targetObservers);
        }
        if (!this.targetRemoving.equals(Replicas.toList(this.partition.removingReplicas))) {
            record.setRemovingReplicas(this.targetRemoving);
        }
        if (!this.targetAdding.equals(Replicas.toList(this.partition.addingReplicas))) {
            record.setAddingReplicas(this.targetAdding);
        }
        if (!this.targetRemovingObservers.equals(Replicas.toList(this.partition.removingObservers))) {
            record.setRemovingObservers(this.targetRemovingObservers);
        }
        if (!this.targetAddingObservers.equals(Replicas.toList(this.partition.addingObservers))) {
            record.setAddingObservers(this.targetAddingObservers);
        }
    }

    private void maybeUpdateLastKnownLeader(PartitionChangeRecord record) {
        if (!this.useLastKnownLeaderInBalancedRecovery || !this.eligibleLeaderReplicasEnabled) {
            return;
        }
        if (record.isr() != null && record.isr().isEmpty() && (this.partition.lastKnownElr.length != 1 || this.partition.lastKnownElr[0] != this.partition.leader)) {
            record.setLastKnownElr(List.of(Integer.valueOf(this.partition.leader)));
        } else if ((record.leader() >= 0 || this.partition.leader != -1 && record.leader() != -1) && this.partition.lastKnownElr.length > 0) {
            record.setLastKnownElr(List.of());
        }
    }

    private void maybeUpdateRecordElr(PartitionChangeRecord record) {
        boolean isCleanLeaderElection;
        boolean bl = isCleanLeaderElection = record.isr() == null;
        if (!isCleanLeaderElection || !this.eligibleLeaderReplicasEnabled) {
            this.targetElr = List.of();
            this.targetLastKnownElr = List.of();
        }
        if (!this.targetElr.equals(Replicas.toList(this.partition.elr))) {
            record.setEligibleLeaderReplicas(this.targetElr);
        }
        if (this.useLastKnownLeaderInBalancedRecovery && this.partition.lastKnownElr.length == 1 && (record.leader() == -1 || record.leader() == -2 && this.partition.leader == -1)) {
            this.targetLastKnownElr = Replicas.toList(this.partition.lastKnownElr);
        }
        if (this.useLastKnownLeaderInBalancedRecovery) {
            return;
        }
        if (!this.targetLastKnownElr.equals(Replicas.toList(this.partition.lastKnownElr))) {
            record.setLastKnownElr(this.targetLastKnownElr);
        }
    }

    private void maybePopulateTargetElr() {
        if (!this.eligibleLeaderReplicasEnabled) {
            return;
        }
        if (this.targetIsr.size() >= this.minISR) {
            this.targetElr = List.of();
            this.targetLastKnownElr = List.of();
            return;
        }
        HashSet<Integer> targetIsrSet = new HashSet<Integer>(this.targetIsr);
        HashSet<Integer> candidateSet = new HashSet<Integer>(this.targetElr);
        Arrays.stream(this.partition.isr).forEach(candidateSet::add);
        this.targetElr = candidateSet.stream().filter(replica -> !targetIsrSet.contains(replica)).filter(replica -> this.uncleanShutdownReplicas == null || !this.uncleanShutdownReplicas.contains(replica)).collect(Collectors.toList());
        candidateSet.addAll(this.targetLastKnownElr);
        this.targetLastKnownElr = candidateSet.stream().filter(replica -> !targetIsrSet.contains(replica)).filter(replica -> !this.targetElr.contains(replica)).collect(Collectors.toList());
    }

    public String toString() {
        return "PartitionChangeBuilder(partition=" + String.valueOf(this.partition) + ", topicId=" + String.valueOf(this.topicId) + ", partitionId=" + this.partitionId + ", isAcceptableLeader=" + String.valueOf(this.isAcceptableLeader) + ", targetIsr=" + String.valueOf(this.targetIsr) + ", targetReplicas=" + String.valueOf(this.targetReplicas) + ", targetObservers=" + String.valueOf(this.targetObservers) + ", targetRemoving=" + String.valueOf(this.targetRemoving) + ", targetAdding=" + String.valueOf(this.targetAdding) + ", targetRemovingObservers=" + String.valueOf(this.targetRemovingObservers) + ", targetAddingObservers=" + String.valueOf(this.targetAddingObservers) + ", targetElr=" + String.valueOf(this.targetElr) + ", targetLastKnownElr=" + String.valueOf(this.targetLastKnownElr) + ", uncleanShutdownReplicas=" + String.valueOf(this.uncleanShutdownReplicas) + ", election=" + String.valueOf((Object)this.election) + ", targetLeaderRecoveryState=" + String.valueOf((Object)this.targetLeaderRecoveryState) + ", linkedLeaderEpoch=" + this.linkedLeaderEpoch + ", linkState=" + String.valueOf((Object)this.linkState) + ")";
    }

    public static enum Election {
        PREFERRED,
        ONLINE,
        UNCLEAN;

    }

    static class ElectionResult {
        final int node;
        final boolean unclean;

        private ElectionResult(int node, boolean unclean) {
            this.node = node;
            this.unclean = unclean;
        }
    }
}

