/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class EncryptedEnvelopeRecord
implements ApiMessage {
    byte[] ciphertext;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("ciphertext", (Type)Type.COMPACT_NULLABLE_BYTES, "The encrypted record bytes."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public EncryptedEnvelopeRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public EncryptedEnvelopeRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public EncryptedEnvelopeRecord() {
        this.ciphertext = Bytes.EMPTY;
    }

    public short apiKey() {
        return 10004;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.ciphertext = null;
        } else {
            byte[] newBytes = _readable.readArray(length);
            this.ciphertext = newBytes;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (this.ciphertext == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.ciphertext.length + 1);
            _writable.writeByteArray(this.ciphertext);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (this.ciphertext == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(this.ciphertext.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.ciphertext.length + 1)));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EncryptedEnvelopeRecord)) {
            return false;
        }
        EncryptedEnvelopeRecord other = (EncryptedEnvelopeRecord)obj;
        if (!Arrays.equals(this.ciphertext, other.ciphertext)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Arrays.hashCode(this.ciphertext);
        return hashCode;
    }

    public EncryptedEnvelopeRecord duplicate() {
        EncryptedEnvelopeRecord _duplicate = new EncryptedEnvelopeRecord();
        _duplicate.ciphertext = (byte[])(this.ciphertext == null ? null : MessageUtil.duplicate((byte[])this.ciphertext));
        return _duplicate;
    }

    public String toString() {
        return "EncryptedEnvelopeRecord(ciphertext=" + Arrays.toString(this.ciphertext) + ")";
    }

    public byte[] ciphertext() {
        return this.ciphertext;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public EncryptedEnvelopeRecord setCiphertext(byte[] v) {
        this.ciphertext = v;
        return this;
    }
}

