/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.queue;

import java.util.OptionalLong;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import org.slf4j.Logger;

public interface EventQueue
extends AutoCloseable {
    default public void prepend(Event event) {
        this.enqueue(EventInsertionType.PREPEND, null, NoDeadlineFunction.INSTANCE, event);
    }

    default public void append(Event event) {
        this.enqueue(EventInsertionType.APPEND, null, NoDeadlineFunction.INSTANCE, event);
    }

    default public void appendWithDeadline(long deadlineNs, Event event) {
        this.enqueue(EventInsertionType.APPEND, null, new DeadlineFunction(deadlineNs), event);
    }

    default public void scheduleDeferred(String tag, Function<OptionalLong, OptionalLong> deadlineNsCalculator, Event event) {
        this.enqueue(EventInsertionType.DEFERRED, tag, deadlineNsCalculator, event);
    }

    public void cancelDeferred(String var1);

    public void enqueue(EventInsertionType var1, String var2, Function<OptionalLong, OptionalLong> var3, Event var4);

    public void beginShutdown(String var1);

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public void wakeup() {
    }

    @Override
    public void close() throws InterruptedException;

    public static enum EventInsertionType {
        PREPEND,
        APPEND,
        DEFERRED;

    }

    public static class NoDeadlineFunction
    implements Function<OptionalLong, OptionalLong> {
        public static final NoDeadlineFunction INSTANCE = new NoDeadlineFunction();

        @Override
        public OptionalLong apply(OptionalLong ignored) {
            return OptionalLong.empty();
        }
    }

    public static interface Event {
        public void run() throws Exception;

        default public String name() {
            return this.getClass().getName();
        }

        default public void handleException(Throwable e) {
        }
    }

    public static class DeadlineFunction
    implements Function<OptionalLong, OptionalLong> {
        private final long deadlineNs;

        public DeadlineFunction(long deadlineNs) {
            this.deadlineNs = deadlineNs;
        }

        @Override
        public OptionalLong apply(OptionalLong ignored) {
            return OptionalLong.of(this.deadlineNs);
        }
    }

    public static class VoidEvent
    implements Event {
        public static final VoidEvent INSTANCE = new VoidEvent();

        @Override
        public void run() throws Exception {
        }
    }

    public static class LatestDeadlineFunction
    implements Function<OptionalLong, OptionalLong> {
        private final long newDeadlineNs;

        public LatestDeadlineFunction(long newDeadlineNs) {
            this.newDeadlineNs = newDeadlineNs;
        }

        @Override
        public OptionalLong apply(OptionalLong prevDeadlineNs) {
            if (prevDeadlineNs.isEmpty()) {
                return OptionalLong.of(this.newDeadlineNs);
            }
            if (prevDeadlineNs.getAsLong() > this.newDeadlineNs) {
                return prevDeadlineNs;
            }
            return OptionalLong.of(this.newDeadlineNs);
        }
    }

    public static class EarliestDeadlineFunction
    implements Function<OptionalLong, OptionalLong> {
        private final long newDeadlineNs;

        public EarliestDeadlineFunction(long newDeadlineNs) {
            this.newDeadlineNs = newDeadlineNs;
        }

        @Override
        public OptionalLong apply(OptionalLong prevDeadlineNs) {
            if (prevDeadlineNs.isEmpty()) {
                return OptionalLong.of(this.newDeadlineNs);
            }
            if (prevDeadlineNs.getAsLong() < this.newDeadlineNs) {
                return prevDeadlineNs;
            }
            return OptionalLong.of(this.newDeadlineNs);
        }
    }

    public static abstract class FailureLoggingEvent
    implements Event {
        private final Logger log;

        public FailureLoggingEvent(Logger log) {
            this.log = log;
        }

        @Override
        public void handleException(Throwable e) {
            if (e instanceof RejectedExecutionException) {
                this.log.info("Not processing {} because the event queue is closed.", (Object)this);
            } else {
                this.log.error("Unexpected error handling {}", (Object)this, (Object)e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

