/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.server.metrics.FilteringJmxReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaYammerMetrics
implements Reconfigurable {
    public static final KafkaYammerMetrics INSTANCE = new KafkaYammerMetrics();
    private static final Logger LOG = LoggerFactory.getLogger(KafkaYammerMetrics.class);
    public static final AtomicInteger BROKER_COUNT = new AtomicInteger(0);
    private final MetricsRegistry metricsRegistry = new MetricsRegistry();
    private final FilteringJmxReporter jmxReporter = new FilteringJmxReporter(this.metricsRegistry, metricName -> true);

    public static MetricsRegistry defaultRegistry() {
        return KafkaYammerMetrics.INSTANCE.metricsRegistry;
    }

    private KafkaYammerMetrics() {
        this.jmxReporter.start();
        Exit.addShutdownHook((String)"kafka-jmx-shutdown-hook", () -> ((FilteringJmxReporter)this.jmxReporter).shutdown());
    }

    public void configure(Map<String, ?> configs) {
        this.reconfigure(configs);
    }

    public Set<String> reconfigurableConfigs() {
        return JmxReporter.RECONFIGURABLE_CONFIGS;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        JmxReporter.compilePredicate(configs);
    }

    public void reconfigure(Map<String, ?> configs) {
        Predicate mBeanPredicate = JmxReporter.compilePredicate(configs);
        this.jmxReporter.updatePredicate(metricName -> mBeanPredicate.test(metricName.getMBeanName()));
    }

    public static MetricName getMetricName(String group, String typeName, String name) {
        return KafkaYammerMetrics.getMetricName(group, typeName, name, null);
    }

    public static MetricName getMetricName(String group, String typeName, String name, LinkedHashMap<String, String> tags) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(group);
        nameBuilder.append(":type=");
        nameBuilder.append(typeName);
        if (!name.isEmpty()) {
            nameBuilder.append(",name=");
            nameBuilder.append(name);
        }
        String scope = KafkaYammerMetrics.toScope(tags).orElse(null);
        Optional<String> tagsName = KafkaYammerMetrics.toMBeanName(tags);
        tagsName.ifPresent(nameBuilder::append);
        return new MetricName(group, typeName, name, scope, nameBuilder.toString());
    }

    private static Optional<String> toMBeanName(LinkedHashMap<String, String> tags) {
        if (tags == null) {
            return Optional.empty();
        }
        LinkedHashMap nonEmptyTags = KafkaYammerMetrics.collectNonEmptyTags(tags, LinkedHashMap::new);
        if (nonEmptyTags.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder tagsString = new StringBuilder();
        for (Map.Entry tagEntry : nonEmptyTags.entrySet()) {
            String sanitizedValue = Sanitizer.jmxSanitize((String)((String)tagEntry.getValue()));
            tagsString.append(",");
            tagsString.append((String)tagEntry.getKey());
            tagsString.append("=");
            tagsString.append(sanitizedValue);
        }
        return Optional.of(tagsString.toString());
    }

    private static <T extends Map<String, String>> T collectNonEmptyTags(Map<String, String> tags, Supplier<T> mapSupplier) {
        Map result = (Map)mapSupplier.get();
        for (Map.Entry<String, String> tagEntry : tags.entrySet()) {
            String tagValue = tagEntry.getValue();
            if ("".equals(tagValue)) continue;
            result.put(tagEntry.getKey(), tagValue);
        }
        return (T)result;
    }

    private static Optional<String> toScope(Map<String, String> tags) {
        if (tags == null) {
            return Optional.empty();
        }
        SortedMap nonEmptyTags = KafkaYammerMetrics.collectNonEmptyTags(tags, TreeMap::new);
        if (nonEmptyTags.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder tagsString = new StringBuilder();
        Iterator iterator = nonEmptyTags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry tagEntry = iterator.next();
            String convertedValue = ((String)tagEntry.getValue()).replaceAll("\\.", "_");
            tagsString.append((String)tagEntry.getKey());
            tagsString.append(".");
            tagsString.append(convertedValue);
            if (!iterator.hasNext()) continue;
            tagsString.append(".");
        }
        return Optional.of(tagsString.toString());
    }

    public static void registerBroker() {
        BROKER_COUNT.incrementAndGet();
    }

    public static void unregisterBroker() {
        if (BROKER_COUNT.decrementAndGet() == 0) {
            KafkaYammerMetrics.INSTANCE.metricsRegistry.allMetrics().keySet().forEach(metric -> {
                LOG.debug("Unregistering stray broker metric {} as all running brokers have now been unregistered from the default metrics registry.", metric);
                KafkaYammerMetrics.INSTANCE.metricsRegistry.removeMetric(metric);
            });
        }
    }
}

