/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsResponseData;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;

public class AlterReplicaExclusionsReply {
    private final boolean wasSuccessful;
    private final boolean wasNoOp;
    private final Set<BrokerReplicaExclusionResult> result;

    public AlterReplicaExclusionsReply(boolean wasSuccessful, boolean wasNoOp, Set<BrokerReplicaExclusionResult> result) {
        this.wasSuccessful = wasSuccessful;
        this.wasNoOp = wasNoOp;
        this.result = new HashSet<BrokerReplicaExclusionResult>(result);
    }

    public boolean wasSuccessful() {
        return this.wasSuccessful;
    }

    public boolean wasSuccessfulNoOp() {
        return this.wasNoOp;
    }

    public Set<BrokerReplicaExclusionResult> exclusionResults() {
        return Collections.unmodifiableSet(this.result);
    }

    public AlterBrokerReplicaExclusionsResponseData toResponseData() {
        List responses = this.exclusionResults().stream().map(r -> {
            AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse response = new AlterBrokerReplicaExclusionsResponseData.BrokerReplicaExclusionResponse().setBrokerId(r.brokerId()).setReason(r.reason()).setExclusionOperationCode(r.opType().id());
            r.apiErrorOptional().ifPresent(error -> response.setExclusionErrorCode(error.error().code()).setExclusionErrorMessage(error.message()));
            return response;
        }).collect(Collectors.toList());
        return new AlterBrokerReplicaExclusionsResponseData().setWasApplied(this.wasSuccessful()).setBrokerExclusions(responses);
    }
}

