/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.image.publisher;

import io.confluent.k2.kafka.image.publisher.K2MetadataPublisher;
import io.confluent.k2.kafka.image.publisher.K2TopicsImageAndVersion;
import io.confluent.kafka.image.publisher.K2KRaftMetadataPublisherHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.fault.FaultHandler;

public class GroupCoordinatorDeletedTopicsPublisher
implements MetadataPublisher,
K2MetadataPublisher,
K2KRaftMetadataPublisherHelper.Callback<MetadataImage, MetadataDelta> {
    private final FaultHandler faultHandler;
    private final GroupCoordinator groupCoordinator;
    private K2KRaftMetadataPublisherHelper<MetadataImage, MetadataDelta> k2KRaftMetadataPublisherHelper = null;

    public static GroupCoordinatorDeletedTopicsPublisher newInstance(FaultHandler faultHandler, GroupCoordinator groupCoordinator) {
        GroupCoordinatorDeletedTopicsPublisher publisher = new GroupCoordinatorDeletedTopicsPublisher(faultHandler, groupCoordinator);
        publisher.k2KRaftMetadataPublisherHelper = new K2KRaftMetadataPublisherHelper<MetadataImage, MetadataDelta>(MetadataImage.EMPTY, () -> new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory()), (__, delta) -> delta.topicsDelta() != null && !delta.topicsDelta().deletedTopicIds().isEmpty(), (__, ___) -> "KRaft MetadataDelta", (prevK2, currentK2) -> currentK2.topicIdToNameVersion() != prevK2.topicIdToNameVersion(), publisher);
        return publisher;
    }

    private GroupCoordinatorDeletedTopicsPublisher(FaultHandler faultHandler, GroupCoordinator groupCoordinator) {
        this.faultHandler = Objects.requireNonNull(faultHandler);
        this.groupCoordinator = Objects.requireNonNull(groupCoordinator);
    }

    @Override
    public void doPublish(MetadataImage currentKRaftImage, MetadataDelta currentKRaftDelta, LoaderManifest manifest, K2TopicsImageAndVersion prevK2TopicsImageAndVersion, K2TopicsImageAndVersion currentK2TopicsImageAndVersion, boolean dueToKRaftChange, String description) {
        try {
            List<TopicPartition> deletedTopicPartitions = GroupCoordinatorDeletedTopicsPublisher.getDeletedTopicPartitions(currentKRaftDelta, prevK2TopicsImageAndVersion, currentK2TopicsImageAndVersion, dueToKRaftChange);
            if (!deletedTopicPartitions.isEmpty()) {
                this.groupCoordinator.onPartitionsDeleted(deletedTopicPartitions, BufferSupplier.NO_CACHING);
            }
        }
        catch (Throwable e) {
            this.faultHandler.handleFault("Failed to notify group coordinator of deleted partitions " + String.valueOf(dueToKRaftChange ? manifest.provenance() : "K2 image at (local, soft-state) topics version " + currentK2TopicsImageAndVersion.topicIdToNameVersion() + " and assignments version " + currentK2TopicsImageAndVersion.assignmentsVersion() + ")"), e);
        }
    }

    private static List<TopicPartition> getDeletedTopicPartitions(MetadataDelta currentKRaftDelta, K2TopicsImageAndVersion prevK2TopicsImageAndVersion, K2TopicsImageAndVersion currentK2TopicsImageAndVersion, boolean dueToKRaftChange) {
        if (dueToKRaftChange) {
            TopicsDelta topicsDelta = currentKRaftDelta.topicsDelta();
            return topicsDelta == null ? Collections.emptyList() : topicsDelta.deletedTopicIds().stream().map(deletedTopicId -> topicsDelta.image().getTopic(deletedTopicId)).flatMap(deletedTopicImage -> deletedTopicImage.partitions().keySet().stream().map(partitionId -> new TopicPartition(deletedTopicImage.name(), partitionId.intValue()))).collect(Collectors.toList());
        }
        return currentK2TopicsImageAndVersion.image().partitionsDeletedRelativeTo(prevK2TopicsImageAndVersion.image());
    }

    public void onK2MetadataUpdate(K2TopicsImageAndVersion currentK2TopicsImageAndVersion) {
        this.k2KRaftMetadataPublisherHelper.maybePublishK2ImageAndVersion(currentK2TopicsImageAndVersion);
    }

    public String name() {
        return "GroupCoordinatorDeletedTopicsPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.k2KRaftMetadataPublisherHelper.maybePublishKRaftImageAndDelta(newImage, delta, manifest);
    }
}

