/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security;

import java.util.Collection;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;

public class CredentialProvider {
    public final DelegationTokenCache tokenCache;
    public final CredentialCache credentialCache = new CredentialCache();

    public CredentialProvider(Collection<String> scramMechanisms, DelegationTokenCache tokenCache) {
        this.tokenCache = tokenCache;
        ScramCredentialUtils.createCache((CredentialCache)this.credentialCache, scramMechanisms);
    }

    public void updateCredential(ScramMechanism mechanism, String name, ScramCredential credential) {
        CredentialCache.Cache cache = this.credentialCache.cache(mechanism.mechanismName(), ScramCredential.class);
        cache.put(name, (Object)credential);
    }

    public void removeCredentials(ScramMechanism mechanism, String name) {
        CredentialCache.Cache cache = this.credentialCache.cache(mechanism.mechanismName(), ScramCredential.class);
        if (cache != null) {
            cache.remove(name);
        }
    }

    public CredentialCache credentialCache() {
        return this.credentialCache;
    }
}

