/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.storage.internals.log.VerificationGuard;

public class VerificationStateEntry {
    private final long timestamp;
    private final VerificationGuard verificationGuard;
    private int lowestSequence;
    private short epoch;

    public VerificationStateEntry(long timestamp, int sequence, short epoch) {
        this.timestamp = timestamp;
        this.verificationGuard = new VerificationGuard();
        this.lowestSequence = sequence;
        this.epoch = epoch;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public VerificationGuard verificationGuard() {
        return this.verificationGuard;
    }

    public int lowestSequence() {
        return this.lowestSequence;
    }

    public short epoch() {
        return this.epoch;
    }

    public void maybeUpdateLowestSequenceAndEpoch(int incomingSequence, short incomingEpoch) {
        if (incomingEpoch == this.epoch && incomingSequence < this.lowestSequence) {
            this.lowestSequence = incomingSequence;
        }
        if (incomingEpoch > this.epoch) {
            this.epoch = incomingEpoch;
            this.lowestSequence = incomingSequence;
        }
    }
}

