/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.MergedLogUtils;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.StorageAction;
import org.slf4j.Logger;

public class LogLoader {
    private static final String SNAPSHOT_DELETE_SUFFIX = ".checkpoint.deleted";
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final LeaderEpochFileCache leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private final ConcurrentMap<String, Integer> numRemainingSegments;
    private final ChecksumParams checksumParams;
    private final boolean isRemoteLogEnabled;
    private final Logger logger;
    private final String logPrefix;

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, LeaderEpochFileCache leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Integer> numRemainingSegments, ChecksumParams checksumParams, boolean isRemoteLogEnabled) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.numRemainingSegments = numRemainingSegments;
        this.checksumParams = checksumParams;
        this.isRemoteLogEnabled = isRemoteLogEnabled;
        this.logPrefix = "[LogLoader partition=" + String.valueOf(topicPartition) + ", dir=" + dir.getParent() + "] ";
        this.logger = new LogContext(this.logPrefix).logger(LogLoader.class);
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, LeaderEpochFileCache leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Integer> numRemainingSegments, ChecksumParams checksumParams) {
        this(dir, topicPartition, config, scheduler, time, logDirFailureChannel, hadCleanShutdown, segments, logStartOffsetCheckpoint, recoveryPointCheckpoint, leaderEpochCache, producerStateManager, numRemainingSegments, checksumParams, false);
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() throws IOException {
        void var7_10;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        long minSwapFileOffset = Long.MAX_VALUE;
        long maxSwapFileOffset = Long.MIN_VALUE;
        for (File file : swapFiles) {
            if (!LogFileUtils.isLogFile(new File(Utils.replaceSuffix((String)file.getPath(), (String)".swap", (String)"")))) continue;
            long baseOffset = LogFileUtils.offsetFromFile(file);
            LogSegment segment = LogSegment.open(file.getParentFile(), baseOffset, this.config, this.time, true, 0, false, ".swap", this.checksumParams);
            this.logger.info("Found log file {} from interrupted swap operation, which is recoverable from {} files by renaming.", (Object)file.getPath(), (Object)".swap");
            minSwapFileOffset = Math.min(segment.baseOffset(), minSwapFileOffset);
            maxSwapFileOffset = Math.max(segment.readNextOffset(), maxSwapFileOffset);
        }
        File[] files = this.dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            try {
                long offset;
                if (file.getName().endsWith(".swap") || (offset = LogFileUtils.offsetFromFile(file).longValue()) < minSwapFileOffset || offset >= maxSwapFileOffset) continue;
                this.logger.info("Deleting segment files {} that is compacted but has not been deleted yet.", (Object)file.getName());
                boolean bl = file.delete();
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException runtimeException) {
                // empty catch block
            }
        }
        files = this.dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".swap")) continue;
            this.logger.info("Recovering file {} by renaming from {} files.", (Object)file.getName(), (Object)".swap");
            boolean bl = file.renameTo(new File(Utils.replaceSuffix((String)file.getPath(), (String)".swap", (String)"")));
        }
        this.retryOnOffsetOverflow(() -> {
            this.segments.close();
            this.segments.clear();
            this.loadSegmentFiles();
            return null;
        });
        if (!this.dir.getAbsolutePath().endsWith("-delete")) {
            RecoveryOffsets recoveryOffsets = this.retryOnOffsetOverflow(this::recoverLog);
            this.segments.lastSegment().get().resizeIndexes(this.config.maxIndexSize);
        } else {
            if (this.segments.isEmpty()) {
                this.segments.add(LogSegment.open(this.dir, 0L, this.config, this.time, this.config.initFileSize(), false, this.checksumParams));
            }
            RecoveryOffsets recoveryOffsets = new RecoveryOffsets(0L, 0L);
        }
        this.leaderEpochCache.truncateFromEndAsyncFlush(var7_10.nextOffset);
        this.leaderEpochCache.truncateFromStartAsyncFlush(this.logStartOffsetCheckpoint);
        this.producerStateManager.removeStraySnapshots(this.segments.baseOffsets());
        LogSegment activeSegment = this.segments.lastSegment().get();
        return new LoadedLogOffsets(var7_10.newRecoveryPoint, new LogOffsetMetadata(var7_10.nextOffset, activeSegment.baseOffset(), activeSegment.size()));
    }

    private Set<File> removeTempFilesAndCollectSwapFiles() throws IOException {
        HashSet<File> swapFiles = new HashSet<File>();
        HashSet<File> cleanedFiles = new HashSet<File>();
        long minCleanedFileOffset = Long.MAX_VALUE;
        File[] files = this.dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            if (!file.canRead()) {
                throw new IOException("Could not read file " + String.valueOf(file));
            }
            String filename = file.getName();
            if (filename.endsWith(".deleted") && !filename.endsWith(SNAPSHOT_DELETE_SUFFIX)) {
                this.logger.debug("Deleting stray temporary file {}", (Object)file.getAbsolutePath());
                FilesWrapper.deleteIfExists((Path)file.toPath());
                continue;
            }
            if (filename.endsWith(".cleaned")) {
                minCleanedFileOffset = Math.min(LogFileUtils.offsetFromFile(file), minCleanedFileOffset);
                cleanedFiles.add(file);
                continue;
            }
            if (filename.endsWith(".tiercleaned")) {
                cleanedFiles.add(file);
                continue;
            }
            if (!filename.endsWith(".swap")) continue;
            swapFiles.add(file);
        }
        HashSet<File> invalidSwapFiles = new HashSet<File>();
        HashSet<File> validSwapFiles = new HashSet<File>();
        for (File file : swapFiles) {
            if (LogFileUtils.offsetFromFile(file) >= minCleanedFileOffset) {
                invalidSwapFiles.add(file);
                continue;
            }
            validSwapFiles.add(file);
        }
        for (File file : invalidSwapFiles) {
            this.logger.debug("Deleting invalid swap file {} minCleanedFileOffset: {}", (Object)file.getAbsoluteFile(), (Object)minCleanedFileOffset);
            FilesWrapper.deleteIfExists((Path)file.toPath());
        }
        for (File file : cleanedFiles) {
            this.logger.debug("Deleting stray .clean file {}", (Object)file.getAbsolutePath());
            FilesWrapper.deleteIfExists((Path)file.toPath());
        }
        return validSwapFiles;
    }

    private <T> T retryOnOffsetOverflow(StorageAction<T, IOException> function) throws IOException {
        while (true) {
            try {
                return function.execute();
            }
            catch (LogSegmentOffsetOverflowException lsooe) {
                this.logger.info("Caught segment overflow error: {}. Split segment and retry.", (Object)lsooe.getMessage());
                LocalLog.SplitSegmentResult result = LocalLog.splitOverflowedSegment(lsooe.segment, this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logPrefix);
                this.deleteProducerSnapshotsAsync(result.deletedSegments);
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() throws IOException {
        File[] files = this.dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        List<File> sortedFiles = Arrays.stream(files).filter(File::isFile).sorted().toList();
        for (File file : sortedFiles) {
            if (LogFileUtils.isIndexFile(file)) {
                long offset = LogFileUtils.offsetFromFile(file);
                File logFile = LogFileUtils.logFile(this.dir, offset);
                if (logFile.exists()) continue;
                this.logger.warn("Found an orphaned index file {}, with no corresponding log file.", (Object)file.getAbsolutePath());
                FilesWrapper.deleteIfExists((Path)file.toPath());
                continue;
            }
            if (!LogFileUtils.isLogFile(file)) continue;
            long baseOffset = LogFileUtils.offsetFromFile(file);
            boolean timeIndexFileNewlyCreated = !LogFileUtils.timeIndexFile(this.dir, baseOffset).exists();
            LogSegment segment = LogSegment.open(this.dir, baseOffset, this.config, this.time, true, 0, false, "", this.checksumParams);
            try {
                segment.sanityCheck(timeIndexFileNewlyCreated);
            }
            catch (NoSuchFileException nsfe) {
                if (this.hadCleanShutdown || segment.baseOffset() < this.recoveryPointCheckpoint) {
                    this.logger.error("Could not find offset index file corresponding to log file {}, recovering segment and rebuilding index files...", (Object)segment.log().file().getAbsolutePath());
                }
                this.recoverSegment(segment);
            }
            catch (CorruptIndexException cie) {
                this.logger.warn("Found a corrupted index file corresponding to log file {} due to {}, recovering segment and rebuilding index files...", (Object)segment.log().file().getAbsolutePath(), (Object)cie.getMessage());
                this.recoverSegment(segment);
            }
            this.segments.add(segment);
        }
    }

    private int recoverSegment(LogSegment segment) throws IOException {
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.producerStateManagerConfig(), this.time, Optional.empty(), this.checksumParams);
        MergedLogUtils.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.time, false, this.logPrefix);
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache);
        producerStateManager.takeSnapshot();
        return bytesTruncated;
    }

    private Optional<Long> deleteSegmentsIfLogStartGreaterThanLogEnd() throws IOException {
        if (this.segments.nonEmpty()) {
            long logEndOffset = this.segments.lastSegment().get().readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return Optional.of(logEndOffset);
            }
            this.logger.warn("Deleting all segments because logEndOffset ({}) is smaller than logStartOffset {}. This could happen if segment files were deleted from the file system.", (Object)logEndOffset, (Object)this.logStartOffsetCheckpoint);
            this.removeAndDeleteSegmentsAsync(this.segments.values());
            this.leaderEpochCache.clearAndFlush();
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return Optional.empty();
        }
        return Optional.empty();
    }

    RecoveryOffsets recoverLog() throws IOException {
        if (!this.hadCleanShutdown) {
            Collection<LogSegment> unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE);
            int numUnflushed = unflushed.size();
            Iterator<LogSegment> unflushedIter = unflushed.iterator();
            boolean truncated = false;
            int numFlushed = 0;
            String threadName = Thread.currentThread().getName();
            this.numRemainingSegments.put(threadName, numUnflushed);
            while (unflushedIter.hasNext() && !truncated) {
                int truncatedBytes;
                LogSegment segment = unflushedIter.next();
                this.logger.info("Recovering unflushed segment {}. {} recovered for {}.", new Object[]{segment.baseOffset(), numFlushed / numUnflushed, this.topicPartition});
                try {
                    truncatedBytes = this.recoverSegment(segment);
                }
                catch (IOException | InvalidOffsetException ioe) {
                    long startOffset = segment.baseOffset();
                    this.logger.warn("Found invalid offset during recovery. Deleting the corrupt segment and creating an empty one with starting offset {}", (Object)startOffset);
                    truncatedBytes = segment.truncateTo(startOffset);
                }
                if (truncatedBytes > 0) {
                    this.logger.warn("Corruption found in segment {}, truncating to offset {}", (Object)segment.baseOffset(), (Object)segment.readNextOffset());
                    ArrayList<LogSegment> unflushedRemaining = new ArrayList<LogSegment>();
                    unflushedIter.forEachRemaining(unflushedRemaining::add);
                    this.removeAndDeleteSegmentsAsync(unflushedRemaining);
                    truncated = true;
                    this.numRemainingSegments.put(threadName, 0);
                    continue;
                }
                this.numRemainingSegments.put(threadName, numUnflushed - ++numFlushed);
            }
        }
        Optional<Long> logEndOffsetOptional = this.deleteSegmentsIfLogStartGreaterThanLogEnd();
        if (this.segments.isEmpty()) {
            this.segments.add(LogSegment.open(this.dir, this.logStartOffsetCheckpoint, this.config, this.time, this.config.initFileSize(), this.config.preallocate, this.checksumParams));
        }
        if (this.hadCleanShutdown && logEndOffsetOptional.isPresent()) {
            return new RecoveryOffsets(logEndOffsetOptional.get(), logEndOffsetOptional.get());
        }
        long logEndOffset = logEndOffsetOptional.orElse(this.segments.lastSegment().get().readNextOffset());
        return new RecoveryOffsets(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
    }

    private void removeAndDeleteSegmentsAsync(Collection<LogSegment> segmentsToDelete) throws IOException {
        if (!segmentsToDelete.isEmpty()) {
            ArrayList<LogSegment> toDelete = new ArrayList<LogSegment>(segmentsToDelete);
            this.logger.info("Deleting segments as part of log recovery: {}", (Object)toDelete.stream().map(LogSegment::toString).collect(Collectors.joining(", ")));
            toDelete.forEach(segment -> this.segments.remove(segment.baseOffset()));
            LocalLog.deleteSegmentFiles(toDelete, true, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logPrefix);
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
        }
    }

    private void deleteProducerSnapshotsAsync(Collection<LogSegment> segments) throws IOException {
        MergedLogUtils.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition, this.checksumParams.checksumStoreOpt());
    }

    static class RecoveryOffsets {
        final long newRecoveryPoint;
        final long nextOffset;

        RecoveryOffsets(long newRecoveryPoint, long nextOffset) {
            this.newRecoveryPoint = newRecoveryPoint;
            this.nextOffset = nextOffset;
        }
    }
}

