/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import org.apache.kafka.streams.kstream.internals.StatelessProcessorNode;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

class StatefulProcessorNode<K, V>
extends StatelessProcessorNode<K, V> {
    private final String[] storeNames;
    private final StateStoreSupplier<KeyValueStore> storeSupplier;
    private final StoreBuilder<KeyValueStore<K, V>> storeBuilder;

    StatefulProcessorNode(String parentNodeName, String processorNodeName, ProcessorSupplier<K, V> processorSupplier, String[] storeNames, StateStoreSupplier<KeyValueStore> storeSupplier, StoreBuilder<KeyValueStore<K, V>> storeBuilder, boolean repartitionRequired) {
        super(parentNodeName, processorNodeName, processorSupplier, repartitionRequired);
        this.storeNames = storeNames;
        this.storeSupplier = storeSupplier;
        this.storeBuilder = storeBuilder;
    }

    String[] storeNames() {
        return Arrays.copyOf(this.storeNames, this.storeNames.length);
    }

    StateStoreSupplier<KeyValueStore> storeSupplier() {
        return this.storeSupplier;
    }

    StoreBuilder<KeyValueStore<K, V>> storeBuilder() {
        return this.storeBuilder;
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }

    static <K, V> StatefulProcessorNodeBuilder<K, V> statefulProcessorNodeBuilder() {
        return new StatefulProcessorNodeBuilder();
    }

    static final class StatefulProcessorNodeBuilder<K, V> {
        private ProcessorSupplier processorSupplier;
        private String processorNodeName;
        private String parentProcessorNodeName;
        private boolean repartitionRequired;
        private String[] storeNames;
        private StateStoreSupplier<KeyValueStore> storeSupplier;
        private StoreBuilder<KeyValueStore<K, V>> storeBuilder;

        private StatefulProcessorNodeBuilder() {
        }

        StatefulProcessorNodeBuilder<K, V> withProcessorSupplier(ProcessorSupplier processorSupplier) {
            this.processorSupplier = processorSupplier;
            return this;
        }

        StatefulProcessorNodeBuilder<K, V> withProcessorNodeName(String processorNodeName) {
            this.processorNodeName = processorNodeName;
            return this;
        }

        StatefulProcessorNodeBuilder<K, V> withParentProcessorNodeName(String parentProcessorNodeName) {
            this.parentProcessorNodeName = parentProcessorNodeName;
            return this;
        }

        StatefulProcessorNodeBuilder<K, V> withStoreNames(String[] storeNames) {
            this.storeNames = storeNames;
            return this;
        }

        StatefulProcessorNodeBuilder<K, V> withRepartitionRequired(boolean repartitionRequired) {
            this.repartitionRequired = repartitionRequired;
            return this;
        }

        StatefulProcessorNodeBuilder<K, V> withStoreSupplier(StateStoreSupplier<KeyValueStore> storeSupplier) {
            this.storeSupplier = storeSupplier;
            return this;
        }

        StatefulProcessorNodeBuilder<K, V> withStoreBuilder(StoreBuilder<KeyValueStore<K, V>> storeBuilder) {
            this.storeBuilder = storeBuilder;
            return this;
        }

        StatefulProcessorNode<K, V> build() {
            return new StatefulProcessorNode<K, V>(this.parentProcessorNodeName, this.processorNodeName, this.processorSupplier, this.storeNames, this.storeSupplier, this.storeBuilder, this.repartitionRequired);
        }
    }
}

