/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SubscriptionInfoData
implements ApiMessage {
    private int version;
    private int latestSupportedVersion;
    private UUID processId;
    private List<TaskId> prevTasks;
    private List<TaskId> standbyTasks;
    private byte[] userEndPoint;
    private List<TaskOffsetSum> taskOffsetSums;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), "")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("user_end_point", (Type)Type.BYTES, "")});
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public SubscriptionInfoData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SubscriptionInfoData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public SubscriptionInfoData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public SubscriptionInfoData() {
        this.version = 0;
        this.latestSupportedVersion = -1;
        this.processId = MessageUtil.ZERO_UUID;
        this.prevTasks = new ArrayList<TaskId>(0);
        this.standbyTasks = new ArrayList<TaskId>(0);
        this.userEndPoint = Bytes.EMPTY;
        this.taskOffsetSums = new ArrayList<TaskOffsetSum>(0);
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 1;
    }

    public short highestSupportedVersion() {
        return 7;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<TaskId> newCollection;
        int arrayLength;
        this.version = _readable.readInt();
        this.latestSupportedVersion = _version >= 3 ? _readable.readInt() : -1;
        this.processId = _readable.readUUID();
        if (_version <= 6) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field prevTasks was serialized as null");
            }
            newCollection = new ArrayList<TaskId>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskId(_readable, _version));
            }
            this.prevTasks = newCollection;
        } else {
            this.prevTasks = new ArrayList<TaskId>(0);
        }
        if (_version <= 6) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field standbyTasks was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskId(_readable, _version));
            }
            this.standbyTasks = newCollection;
        } else {
            this.standbyTasks = new ArrayList<TaskId>(0);
        }
        if (_version >= 2) {
            int length = _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field userEndPoint was serialized as null");
            }
            byte[] newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.userEndPoint = newBytes;
        } else {
            this.userEndPoint = Bytes.EMPTY;
        }
        if (_version >= 7) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field taskOffsetSums was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((TaskId)((Object)new TaskOffsetSum(_readable, _version)));
            }
            this.taskOffsetSums = newCollection;
        } else {
            this.taskOffsetSums = new ArrayList<TaskOffsetSum>(0);
        }
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        RawTaggedFieldWriter _rawWriter;
        int _numTaggedFields = 0;
        _writable.writeInt(this.version);
        if (_version >= 3) {
            _writable.writeInt(this.latestSupportedVersion);
        } else if (this.latestSupportedVersion != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default latestSupportedVersion at version " + _version);
        }
        _writable.writeUUID(this.processId);
        if (_version <= 6) {
            _writable.writeInt(this.prevTasks.size());
            for (TaskId prevTasksElement : this.prevTasks) {
                prevTasksElement.write(_writable, _cache, _version);
            }
        } else if (!this.prevTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default prevTasks at version " + _version);
        }
        if (_version <= 6) {
            _writable.writeInt(this.standbyTasks.size());
            for (TaskId standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.write(_writable, _cache, _version);
            }
        } else if (!this.standbyTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default standbyTasks at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeInt(this.userEndPoint.length);
            _writable.writeByteArray(this.userEndPoint);
        } else if (this.userEndPoint.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default userEndPoint at version " + _version);
        }
        if (_version >= 7) {
            _writable.writeInt(this.taskOffsetSums.size());
            for (TaskOffsetSum taskOffsetSumsElement : this.taskOffsetSums) {
                taskOffsetSumsElement.write(_writable, _cache, _version);
            }
        } else if (!this.taskOffsetSums.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default taskOffsetSums at version " + _version);
        }
        if ((_numTaggedFields += (_rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields)).numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        Object[] _nestedObjects;
        this._unknownTaggedFields = null;
        this.version = struct.getInt("version");
        this.latestSupportedVersion = _version >= 3 ? struct.getInt("latest_supported_version") : -1;
        this.processId = struct.getUUID("process_id");
        if (_version <= 6) {
            _nestedObjects = struct.getArray("prev_tasks");
            this.prevTasks = new ArrayList<TaskId>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.prevTasks.add(new TaskId((Struct)nestedObject, _version));
            }
        } else {
            this.prevTasks = new ArrayList<TaskId>(0);
        }
        if (_version <= 6) {
            _nestedObjects = struct.getArray("standby_tasks");
            this.standbyTasks = new ArrayList<TaskId>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.standbyTasks.add(new TaskId((Struct)nestedObject, _version));
            }
        } else {
            this.standbyTasks = new ArrayList<TaskId>(0);
        }
        this.userEndPoint = _version >= 2 ? struct.getByteArray("user_end_point") : Bytes.EMPTY;
        if (_version >= 7) {
            _nestedObjects = struct.getArray("task_offset_sums");
            this.taskOffsetSums = new ArrayList<TaskOffsetSum>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.taskOffsetSums.add(new TaskOffsetSum((Struct)nestedObject, _version));
            }
        } else {
            this.taskOffsetSums = new ArrayList<TaskOffsetSum>(0);
        }
    }

    public Struct toStruct(short _version) {
        int i;
        Struct[] _nestedObjects;
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("version", (Object)this.version);
        if (_version >= 3) {
            struct.set("latest_supported_version", (Object)this.latestSupportedVersion);
        } else if (this.latestSupportedVersion != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default latestSupportedVersion at version " + _version);
        }
        struct.set("process_id", (Object)this.processId);
        if (_version <= 6) {
            _nestedObjects = new Struct[this.prevTasks.size()];
            i = 0;
            for (TaskId taskId : this.prevTasks) {
                _nestedObjects[i++] = taskId.toStruct(_version);
            }
            struct.set("prev_tasks", (Object)_nestedObjects);
        } else if (!this.prevTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default prevTasks at version " + _version);
        }
        if (_version <= 6) {
            _nestedObjects = new Struct[this.standbyTasks.size()];
            i = 0;
            for (TaskId taskId : this.standbyTasks) {
                _nestedObjects[i++] = taskId.toStruct(_version);
            }
            struct.set("standby_tasks", (Object)_nestedObjects);
        } else if (!this.standbyTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default standbyTasks at version " + _version);
        }
        if (_version >= 2) {
            struct.setByteArray("user_end_point", this.userEndPoint);
        } else if (this.userEndPoint.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default userEndPoint at version " + _version);
        }
        if (_version >= 7) {
            _nestedObjects = new Struct[this.taskOffsetSums.size()];
            i = 0;
            for (TaskOffsetSum taskOffsetSum : this.taskOffsetSums) {
                _nestedObjects[i++] = taskOffsetSum.toStruct(_version);
            }
            struct.set("task_offset_sums", (Object)_nestedObjects);
        } else if (!this.taskOffsetSums.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default taskOffsetSums at version " + _version);
        }
        return struct;
    }

    public void fromJson(JsonNode _node, short _version) {
        JsonNode _versionNode = _node.get("version");
        if (_versionNode == null) {
            throw new RuntimeException("SubscriptionInfoData: unable to locate field 'version', which is mandatory in version " + _version);
        }
        this.version = MessageUtil.jsonNodeToInt((JsonNode)_versionNode, (String)"SubscriptionInfoData");
        JsonNode _latestSupportedVersionNode = _node.get("latestSupportedVersion");
        if (_latestSupportedVersionNode == null) {
            if (_version >= 3) {
                throw new RuntimeException("SubscriptionInfoData: unable to locate field 'latestSupportedVersion', which is mandatory in version " + _version);
            }
            this.latestSupportedVersion = -1;
        } else {
            this.latestSupportedVersion = MessageUtil.jsonNodeToInt((JsonNode)_latestSupportedVersionNode, (String)"SubscriptionInfoData");
        }
        JsonNode _processIdNode = _node.get("processId");
        if (_processIdNode == null) {
            throw new RuntimeException("SubscriptionInfoData: unable to locate field 'processId', which is mandatory in version " + _version);
        }
        if (!_processIdNode.isTextual()) {
            throw new RuntimeException("SubscriptionInfoData expected a JSON string type, but got " + _node.getNodeType());
        }
        this.processId = UUID.fromString(_processIdNode.asText());
        JsonNode _prevTasksNode = _node.get("prevTasks");
        if (_prevTasksNode == null) {
            if (_version <= 6) {
                throw new RuntimeException("SubscriptionInfoData: unable to locate field 'prevTasks', which is mandatory in version " + _version);
            }
            this.prevTasks = new ArrayList<TaskId>(0);
        } else {
            if (!_prevTasksNode.isArray()) {
                throw new RuntimeException("SubscriptionInfoData expected a JSON array, but got " + _node.getNodeType());
            }
            this.prevTasks = new ArrayList<TaskId>();
            for (Object _element : _prevTasksNode) {
                this.prevTasks.add(new TaskId((JsonNode)_element, _version));
            }
        }
        JsonNode _standbyTasksNode = _node.get("standbyTasks");
        if (_standbyTasksNode == null) {
            if (_version <= 6) {
                throw new RuntimeException("SubscriptionInfoData: unable to locate field 'standbyTasks', which is mandatory in version " + _version);
            }
            this.standbyTasks = new ArrayList<TaskId>(0);
        } else {
            if (!_standbyTasksNode.isArray()) {
                throw new RuntimeException("SubscriptionInfoData expected a JSON array, but got " + _node.getNodeType());
            }
            this.standbyTasks = new ArrayList<TaskId>();
            for (JsonNode _element : _standbyTasksNode) {
                this.standbyTasks.add(new TaskId(_element, _version));
            }
        }
        JsonNode _userEndPointNode = _node.get("userEndPoint");
        if (_userEndPointNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("SubscriptionInfoData: unable to locate field 'userEndPoint', which is mandatory in version " + _version);
            }
            this.userEndPoint = Bytes.EMPTY;
        } else {
            this.userEndPoint = MessageUtil.jsonNodeToBinary((JsonNode)_userEndPointNode, (String)"SubscriptionInfoData");
        }
        JsonNode _taskOffsetSumsNode = _node.get("taskOffsetSums");
        if (_taskOffsetSumsNode == null) {
            if (_version >= 7) {
                throw new RuntimeException("SubscriptionInfoData: unable to locate field 'taskOffsetSums', which is mandatory in version " + _version);
            }
            this.taskOffsetSums = new ArrayList<TaskOffsetSum>(0);
        } else {
            if (!_taskOffsetSumsNode.isArray()) {
                throw new RuntimeException("SubscriptionInfoData expected a JSON array, but got " + _node.getNodeType());
            }
            this.taskOffsetSums = new ArrayList<TaskOffsetSum>();
            for (JsonNode _element : _taskOffsetSumsNode) {
                this.taskOffsetSums.add(new TaskOffsetSum(_element, _version));
            }
        }
    }

    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("version", (JsonNode)new IntNode(this.version));
        if (_version >= 3) {
            _node.set("latestSupportedVersion", (JsonNode)new IntNode(this.latestSupportedVersion));
        } else if (this.latestSupportedVersion != -1) {
            throw new UnsupportedVersionException("Attempted to write a non-default latestSupportedVersion at version " + _version);
        }
        _node.set("processId", (JsonNode)new TextNode(this.processId.toString()));
        if (_version <= 6) {
            ArrayNode _prevTasksArray = new ArrayNode(JsonNodeFactory.instance);
            for (TaskId taskId : this.prevTasks) {
                _prevTasksArray.add(taskId.toJson(_version));
            }
            _node.set("prevTasks", (JsonNode)_prevTasksArray);
        } else if (!this.prevTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default prevTasks at version " + _version);
        }
        if (_version <= 6) {
            ArrayNode _standbyTasksArray = new ArrayNode(JsonNodeFactory.instance);
            for (TaskId taskId : this.standbyTasks) {
                _standbyTasksArray.add(taskId.toJson(_version));
            }
            _node.set("standbyTasks", (JsonNode)_standbyTasksArray);
        } else if (!this.standbyTasks.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default standbyTasks at version " + _version);
        }
        if (_version >= 2) {
            _node.set("userEndPoint", (JsonNode)new BinaryNode(Arrays.copyOf(this.userEndPoint, this.userEndPoint.length)));
        } else if (this.userEndPoint.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default userEndPoint at version " + _version);
        }
        if (_version >= 7) {
            ArrayNode _taskOffsetSumsArray = new ArrayNode(JsonNodeFactory.instance);
            for (TaskOffsetSum taskOffsetSum : this.taskOffsetSums) {
                _taskOffsetSumsArray.add(taskOffsetSum.toJson(_version));
            }
            _node.set("taskOffsetSums", (JsonNode)_taskOffsetSumsArray);
        } else if (!this.taskOffsetSums.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default taskOffsetSums at version " + _version);
        }
        return _node;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _arraySize;
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        if (_version >= 3) {
            _size += 4;
        }
        _size += 16;
        if (_version <= 6) {
            _arraySize = 0;
            _arraySize += 4;
            for (TaskId prevTasksElement : this.prevTasks) {
                _arraySize += prevTasksElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version <= 6) {
            _arraySize = 0;
            _arraySize += 4;
            for (TaskId standbyTasksElement : this.standbyTasks) {
                _arraySize += standbyTasksElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version >= 2) {
            int _bytesSize = this.userEndPoint.length;
            _size += (_bytesSize += 4);
        }
        if (_version >= 7) {
            _arraySize = 0;
            _arraySize += 4;
            for (TaskOffsetSum taskOffsetSumsElement : this.taskOffsetSums) {
                _arraySize += taskOffsetSumsElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SubscriptionInfoData)) {
            return false;
        }
        SubscriptionInfoData other = (SubscriptionInfoData)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.latestSupportedVersion != other.latestSupportedVersion) {
            return false;
        }
        if (!this.processId.equals(other.processId)) {
            return false;
        }
        if (this.prevTasks == null ? other.prevTasks != null : !this.prevTasks.equals(other.prevTasks)) {
            return false;
        }
        if (this.standbyTasks == null ? other.standbyTasks != null : !this.standbyTasks.equals(other.standbyTasks)) {
            return false;
        }
        if (!Arrays.equals(this.userEndPoint, other.userEndPoint)) {
            return false;
        }
        return !(this.taskOffsetSums == null ? other.taskOffsetSums != null : !this.taskOffsetSums.equals(other.taskOffsetSums));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.version;
        hashCode = 31 * hashCode + this.latestSupportedVersion;
        hashCode = 31 * hashCode + this.processId.hashCode();
        hashCode = 31 * hashCode + (this.prevTasks == null ? 0 : this.prevTasks.hashCode());
        hashCode = 31 * hashCode + (this.standbyTasks == null ? 0 : this.standbyTasks.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.userEndPoint);
        hashCode = 31 * hashCode + (this.taskOffsetSums == null ? 0 : this.taskOffsetSums.hashCode());
        return hashCode;
    }

    public SubscriptionInfoData duplicate() {
        SubscriptionInfoData _duplicate = new SubscriptionInfoData();
        _duplicate.version = this.version;
        _duplicate.latestSupportedVersion = this.latestSupportedVersion;
        _duplicate.processId = this.processId;
        ArrayList<TaskId> newPrevTasks = new ArrayList<TaskId>(this.prevTasks.size());
        for (TaskId taskId : this.prevTasks) {
            newPrevTasks.add(taskId.duplicate());
        }
        _duplicate.prevTasks = newPrevTasks;
        ArrayList<TaskId> newStandbyTasks = new ArrayList<TaskId>(this.standbyTasks.size());
        for (TaskId _element : this.standbyTasks) {
            newStandbyTasks.add(_element.duplicate());
        }
        _duplicate.standbyTasks = newStandbyTasks;
        _duplicate.userEndPoint = MessageUtil.duplicate((byte[])this.userEndPoint);
        ArrayList<TaskOffsetSum> arrayList = new ArrayList<TaskOffsetSum>(this.taskOffsetSums.size());
        for (TaskOffsetSum _element : this.taskOffsetSums) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.taskOffsetSums = arrayList;
        return _duplicate;
    }

    public String toString() {
        return "SubscriptionInfoData(version=" + this.version + ", latestSupportedVersion=" + this.latestSupportedVersion + ", prevTasks=" + MessageUtil.deepToString(this.prevTasks.iterator()) + ", standbyTasks=" + MessageUtil.deepToString(this.standbyTasks.iterator()) + ", userEndPoint=" + Arrays.toString(this.userEndPoint) + ", taskOffsetSums=" + MessageUtil.deepToString(this.taskOffsetSums.iterator()) + ")";
    }

    public int version() {
        return this.version;
    }

    public int latestSupportedVersion() {
        return this.latestSupportedVersion;
    }

    public UUID processId() {
        return this.processId;
    }

    public List<TaskId> prevTasks() {
        return this.prevTasks;
    }

    public List<TaskId> standbyTasks() {
        return this.standbyTasks;
    }

    public byte[] userEndPoint() {
        return this.userEndPoint;
    }

    public List<TaskOffsetSum> taskOffsetSums() {
        return this.taskOffsetSums;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SubscriptionInfoData setVersion(int v) {
        this.version = v;
        return this;
    }

    public SubscriptionInfoData setLatestSupportedVersion(int v) {
        this.latestSupportedVersion = v;
        return this;
    }

    public SubscriptionInfoData setProcessId(UUID v) {
        this.processId = v;
        return this;
    }

    public SubscriptionInfoData setPrevTasks(List<TaskId> v) {
        this.prevTasks = v;
        return this;
    }

    public SubscriptionInfoData setStandbyTasks(List<TaskId> v) {
        this.standbyTasks = v;
        return this;
    }

    public SubscriptionInfoData setUserEndPoint(byte[] v) {
        this.userEndPoint = v;
        return this;
    }

    public SubscriptionInfoData setTaskOffsetSums(List<TaskOffsetSum> v) {
        this.taskOffsetSums = v;
        return this;
    }

    static {
        SCHEMA_6 = SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("latest_supported_version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("prev_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("standby_tasks", (Type)new ArrayOf((Type)TaskId.SCHEMA_1), ""), new Field("user_end_point", (Type)Type.BYTES, "")})));
        SCHEMA_7 = new Schema(new Field[]{new Field("version", (Type)Type.INT32, ""), new Field("latest_supported_version", (Type)Type.INT32, ""), new Field("process_id", (Type)Type.UUID, ""), new Field("user_end_point", (Type)Type.BYTES, ""), new Field("task_offset_sums", (Type)new ArrayOf((Type)TaskOffsetSum.SCHEMA_7), "")});
        SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class TaskOffsetSum
    implements Message {
        private int topicGroupId;
        private List<PartitionToOffsetSum> partitionToOffsetSum;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7 = new Schema(new Field[]{new Field("topic_group_id", (Type)Type.INT32, ""), new Field("partition_to_offset_sum", (Type)new ArrayOf((Type)PartitionToOffsetSum.SCHEMA_7), "")});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7};

        public TaskOffsetSum(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskOffsetSum(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TaskOffsetSum(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public TaskOffsetSum() {
            this.topicGroupId = 0;
            this.partitionToOffsetSum = new ArrayList<PartitionToOffsetSum>(0);
        }

        public short lowestSupportedVersion() {
            return 7;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.topicGroupId = _readable.readInt();
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionToOffsetSum was serialized as null");
            }
            ArrayList<PartitionToOffsetSum> newCollection = new ArrayList<PartitionToOffsetSum>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionToOffsetSum(_readable, _version));
            }
            this.partitionToOffsetSum = newCollection;
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.topicGroupId);
            _writable.writeInt(this.partitionToOffsetSum.size());
            for (PartitionToOffsetSum partitionToOffsetSumElement : this.partitionToOffsetSum) {
                partitionToOffsetSumElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            this._unknownTaggedFields = null;
            this.topicGroupId = struct.getInt("topic_group_id");
            Object[] _nestedObjects = struct.getArray("partition_to_offset_sum");
            this.partitionToOffsetSum = new ArrayList<PartitionToOffsetSum>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionToOffsetSum.add(new PartitionToOffsetSum((Struct)nestedObject, _version));
            }
        }

        public Struct toStruct(short _version) {
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_group_id", (Object)this.topicGroupId);
            Struct[] _nestedObjects = new Struct[this.partitionToOffsetSum.size()];
            int i = 0;
            for (PartitionToOffsetSum element : this.partitionToOffsetSum) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partition_to_offset_sum", (Object)_nestedObjects);
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _topicGroupIdNode = _node.get("topicGroupId");
            if (_topicGroupIdNode == null) {
                throw new RuntimeException("TaskOffsetSum: unable to locate field 'topicGroupId', which is mandatory in version " + _version);
            }
            this.topicGroupId = MessageUtil.jsonNodeToInt((JsonNode)_topicGroupIdNode, (String)"TaskOffsetSum");
            JsonNode _partitionToOffsetSumNode = _node.get("partitionToOffsetSum");
            if (_partitionToOffsetSumNode == null) {
                throw new RuntimeException("TaskOffsetSum: unable to locate field 'partitionToOffsetSum', which is mandatory in version " + _version);
            }
            if (!_partitionToOffsetSumNode.isArray()) {
                throw new RuntimeException("TaskOffsetSum expected a JSON array, but got " + _node.getNodeType());
            }
            this.partitionToOffsetSum = new ArrayList<PartitionToOffsetSum>();
            for (JsonNode _element : _partitionToOffsetSumNode) {
                this.partitionToOffsetSum.add(new PartitionToOffsetSum(_element, _version));
            }
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicGroupId", (JsonNode)new IntNode(this.topicGroupId));
            ArrayNode _partitionToOffsetSumArray = new ArrayNode(JsonNodeFactory.instance);
            for (PartitionToOffsetSum _element : this.partitionToOffsetSum) {
                _partitionToOffsetSumArray.add(_element.toJson(_version));
            }
            _node.set("partitionToOffsetSum", (JsonNode)_partitionToOffsetSumArray);
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            _size += 4;
            int _arraySize = 0;
            _arraySize += 4;
            for (PartitionToOffsetSum partitionToOffsetSumElement : this.partitionToOffsetSum) {
                _arraySize += partitionToOffsetSumElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskOffsetSum)) {
                return false;
            }
            TaskOffsetSum other = (TaskOffsetSum)obj;
            if (this.topicGroupId != other.topicGroupId) {
                return false;
            }
            return !(this.partitionToOffsetSum == null ? other.partitionToOffsetSum != null : !this.partitionToOffsetSum.equals(other.partitionToOffsetSum));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicGroupId;
            hashCode = 31 * hashCode + (this.partitionToOffsetSum == null ? 0 : this.partitionToOffsetSum.hashCode());
            return hashCode;
        }

        public TaskOffsetSum duplicate() {
            TaskOffsetSum _duplicate = new TaskOffsetSum();
            _duplicate.topicGroupId = this.topicGroupId;
            ArrayList<PartitionToOffsetSum> newPartitionToOffsetSum = new ArrayList<PartitionToOffsetSum>(this.partitionToOffsetSum.size());
            for (PartitionToOffsetSum _element : this.partitionToOffsetSum) {
                newPartitionToOffsetSum.add(_element.duplicate());
            }
            _duplicate.partitionToOffsetSum = newPartitionToOffsetSum;
            return _duplicate;
        }

        public String toString() {
            return "TaskOffsetSum(topicGroupId=" + this.topicGroupId + ", partitionToOffsetSum=" + MessageUtil.deepToString(this.partitionToOffsetSum.iterator()) + ")";
        }

        public int topicGroupId() {
            return this.topicGroupId;
        }

        public List<PartitionToOffsetSum> partitionToOffsetSum() {
            return this.partitionToOffsetSum;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskOffsetSum setTopicGroupId(int v) {
            this.topicGroupId = v;
            return this;
        }

        public TaskOffsetSum setPartitionToOffsetSum(List<PartitionToOffsetSum> v) {
            this.partitionToOffsetSum = v;
            return this;
        }
    }

    public static class TaskId
    implements Message {
        private int topicGroupId;
        private int partition;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public TaskId(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskId(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public TaskId(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public TaskId() {
            this.topicGroupId = 0;
            this.partition = 0;
        }

        public short lowestSupportedVersion() {
            return 1;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.topicGroupId = _readable.readInt();
            this.partition = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.topicGroupId);
            _writable.writeInt(this.partition);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            this._unknownTaggedFields = null;
            this.topicGroupId = struct.getInt("topic_group_id");
            this.partition = struct.getInt("partition");
        }

        public Struct toStruct(short _version) {
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_group_id", (Object)this.topicGroupId);
            struct.set("partition", (Object)this.partition);
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _topicGroupIdNode = _node.get("topicGroupId");
            if (_topicGroupIdNode == null) {
                throw new RuntimeException("TaskId: unable to locate field 'topicGroupId', which is mandatory in version " + _version);
            }
            this.topicGroupId = MessageUtil.jsonNodeToInt((JsonNode)_topicGroupIdNode, (String)"TaskId");
            JsonNode _partitionNode = _node.get("partition");
            if (_partitionNode == null) {
                throw new RuntimeException("TaskId: unable to locate field 'partition', which is mandatory in version " + _version);
            }
            this.partition = MessageUtil.jsonNodeToInt((JsonNode)_partitionNode, (String)"TaskId");
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicGroupId", (JsonNode)new IntNode(this.topicGroupId));
            _node.set("partition", (JsonNode)new IntNode(this.partition));
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            _size += 4;
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskId)) {
                return false;
            }
            TaskId other = (TaskId)obj;
            if (this.topicGroupId != other.topicGroupId) {
                return false;
            }
            return this.partition == other.partition;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicGroupId;
            hashCode = 31 * hashCode + this.partition;
            return hashCode;
        }

        public TaskId duplicate() {
            TaskId _duplicate = new TaskId();
            _duplicate.topicGroupId = this.topicGroupId;
            _duplicate.partition = this.partition;
            return _duplicate;
        }

        public String toString() {
            return "TaskId(topicGroupId=" + this.topicGroupId + ", partition=" + this.partition + ")";
        }

        public int topicGroupId() {
            return this.topicGroupId;
        }

        public int partition() {
            return this.partition;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskId setTopicGroupId(int v) {
            this.topicGroupId = v;
            return this;
        }

        public TaskId setPartition(int v) {
            this.partition = v;
            return this;
        }

        static {
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("topic_group_id", (Type)Type.INT32, ""), new Field("partition", (Type)Type.INT32, "")}))))));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class PartitionToOffsetSum
    implements Message {
        private int partition;
        private long offsetSum;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7 = new Schema(new Field[]{new Field("partition", (Type)Type.INT32, ""), new Field("offset_sum", (Type)Type.INT64, "")});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7};

        public PartitionToOffsetSum(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionToOffsetSum(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public PartitionToOffsetSum(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public PartitionToOffsetSum() {
            this.partition = 0;
            this.offsetSum = 0L;
        }

        public short lowestSupportedVersion() {
            return 7;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public void read(Readable _readable, short _version) {
            this.partition = _readable.readInt();
            this.offsetSum = _readable.readLong();
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partition);
            _writable.writeLong(this.offsetSum);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            this._unknownTaggedFields = null;
            this.partition = struct.getInt("partition");
            this.offsetSum = struct.getLong("offset_sum");
        }

        public Struct toStruct(short _version) {
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition", (Object)this.partition);
            struct.set("offset_sum", (Object)this.offsetSum);
            return struct;
        }

        public void fromJson(JsonNode _node, short _version) {
            JsonNode _partitionNode = _node.get("partition");
            if (_partitionNode == null) {
                throw new RuntimeException("PartitionToOffsetSum: unable to locate field 'partition', which is mandatory in version " + _version);
            }
            this.partition = MessageUtil.jsonNodeToInt((JsonNode)_partitionNode, (String)"PartitionToOffsetSum");
            JsonNode _offsetSumNode = _node.get("offsetSum");
            if (_offsetSumNode == null) {
                throw new RuntimeException("PartitionToOffsetSum: unable to locate field 'offsetSum', which is mandatory in version " + _version);
            }
            this.offsetSum = MessageUtil.jsonNodeToLong((JsonNode)_offsetSumNode, (String)"PartitionToOffsetSum");
        }

        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partition", (JsonNode)new IntNode(this.partition));
            _node.set("offsetSum", (JsonNode)new LongNode(this.offsetSum));
            return _node;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            _size += 4;
            _size += 8;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionToOffsetSum)) {
                return false;
            }
            PartitionToOffsetSum other = (PartitionToOffsetSum)obj;
            if (this.partition != other.partition) {
                return false;
            }
            return this.offsetSum == other.offsetSum;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + ((int)(this.offsetSum >> 32) ^ (int)this.offsetSum);
            return hashCode;
        }

        public PartitionToOffsetSum duplicate() {
            PartitionToOffsetSum _duplicate = new PartitionToOffsetSum();
            _duplicate.partition = this.partition;
            _duplicate.offsetSum = this.offsetSum;
            return _duplicate;
        }

        public String toString() {
            return "PartitionToOffsetSum(partition=" + this.partition + ", offsetSum=" + this.offsetSum + ")";
        }

        public int partition() {
            return this.partition;
        }

        public long offsetSum() {
            return this.offsetSum;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionToOffsetSum setPartition(int v) {
            this.partition = v;
            return this;
        }

        public PartitionToOffsetSum setOffsetSum(long v) {
            this.offsetSum = v;
            return this;
        }
    }
}

