/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.internals.graph.BaseRepartitionNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopicProperties;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class UnoptimizableRepartitionNode<K, V>
extends BaseRepartitionNode<K, V> {
    private UnoptimizableRepartitionNode(String nodeName, String sourceName, ProcessorParameters<K, V> processorParameters, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String repartitionTopic, StreamPartitioner<K, V> partitioner, InternalTopicProperties internalTopicProperties) {
        super(nodeName, sourceName, processorParameters, keySerde, valueSerde, sinkName, repartitionTopic, partitioner, internalTopicProperties);
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        topologyBuilder.addInternalTopic(this.repartitionTopic, this.internalTopicProperties);
        topologyBuilder.addProcessor(this.processorParameters.processorName(), this.processorParameters.processorSupplier(), this.parentNodeNames());
        topologyBuilder.addSink(this.sinkName, this.repartitionTopic, this.keySerializer(), this.valueSerializer(), this.partitioner, this.processorParameters.processorName());
        topologyBuilder.addSource(null, this.sourceName, (TimestampExtractor)new FailOnInvalidTimestamp(), this.keyDeserializer(), this.valueDeserializer(), this.repartitionTopic);
    }

    @Override
    public String toString() {
        return "UnoptimizableRepartitionNode{" + super.toString() + " }";
    }

    public static <K, V> UnoptimizableRepartitionNodeBuilder<K, V> unoptimizableRepartitionNodeBuilder() {
        return new UnoptimizableRepartitionNodeBuilder();
    }

    public static final class UnoptimizableRepartitionNodeBuilder<K, V>
    extends BaseRepartitionNode.BaseRepartitionNodeBuilder<K, V, UnoptimizableRepartitionNode<K, V>> {
        @Override
        public UnoptimizableRepartitionNode<K, V> build() {
            return new UnoptimizableRepartitionNode(this.nodeName, this.sourceName, this.processorParameters, this.keySerde, this.valueSerde, this.sinkName, this.repartitionTopic, this.partitioner, this.internalTopicProperties);
        }
    }
}

