/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public final class ProcessorContextUtils {
    private ProcessorContextUtils() {
    }

    public static long getCurrentSystemTime(ProcessorContext context) {
        return context instanceof InternalProcessorContext ? ((InternalProcessorContext)context).currentSystemTimeMs() : System.currentTimeMillis();
    }

    public static StreamsMetricsImpl getMetricsImpl(ProcessorContext context) {
        return (StreamsMetricsImpl)context.metrics();
    }

    public static StreamsMetricsImpl getMetricsImpl(StateStoreContext context) {
        return (StreamsMetricsImpl)context.metrics();
    }

    public static String changelogFor(ProcessorContext context, String storeName) {
        return context instanceof InternalProcessorContext ? ((InternalProcessorContext)context).changelogFor(storeName) : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName);
    }

    public static String changelogFor(StateStoreContext context, String storeName) {
        return context instanceof InternalProcessorContext ? ((InternalProcessorContext)context).changelogFor(storeName) : ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName);
    }

    public static InternalProcessorContext asInternalProcessorContext(ProcessorContext context) {
        if (context instanceof InternalProcessorContext) {
            return (InternalProcessorContext)context;
        }
        throw new IllegalArgumentException("This component requires internal features of Kafka Streams and must be disabled for unit tests.");
    }

    public static InternalProcessorContext asInternalProcessorContext(StateStoreContext context) {
        if (context instanceof InternalProcessorContext) {
            return (InternalProcessorContext)context;
        }
        throw new IllegalArgumentException("This component requires internal features of Kafka Streams and must be disabled for unit tests.");
    }

    public static Serializer<?> getKeySerializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getSerializer(processorContext, true);
    }

    public static Serializer<?> getValueSerializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getSerializer(processorContext, false);
    }

    private static Serializer<?> getSerializer(ProcessorContext processorContext, boolean key) {
        Serde<?> serde = key ? processorContext.keySerde() : processorContext.valueSerde();
        return serde == null ? null : serde.serializer();
    }

    public static Deserializer<?> getKeyDeserializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getDeserializer(processorContext, true);
    }

    public static Deserializer<?> getValueDeserializer(ProcessorContext processorContext) {
        return ProcessorContextUtils.getDeserializer(processorContext, false);
    }

    private static Deserializer<?> getDeserializer(ProcessorContext processorContext, boolean key) {
        Serde<?> serde = key ? processorContext.keySerde() : processorContext.valueSerde();
        return serde == null ? null : serde.deserializer();
    }
}

