/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class HostInfo {
    private final String host;
    private final int port;

    public HostInfo(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static HostInfo buildFromEndpoint(String endPoint) {
        if (endPoint == null || endPoint.trim().isEmpty()) {
            return null;
        }
        String host = Utils.getHost((String)endPoint);
        Integer port = Utils.getPort((String)endPoint);
        if (host == null || port == null) {
            throw new ConfigException(String.format("Error parsing host address %s. Expected format host:port.", endPoint));
        }
        return new HostInfo(host, port);
    }

    public static HostInfo unavailable() {
        return new HostInfo("unavailable", -1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostInfo hostInfo = (HostInfo)o;
        return this.port == hostInfo.port && this.host.equals(hostInfo.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String toString() {
        return "HostInfo{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

