/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;

public class JoinWindows
extends Windows<Window> {
    public final long beforeMs;
    public final long afterMs;
    private final long graceMs;
    protected final boolean enableSpuriousResultFix;

    protected JoinWindows(JoinWindows joinWindows) {
        this(joinWindows.beforeMs, joinWindows.afterMs, joinWindows.graceMs, joinWindows.enableSpuriousResultFix);
    }

    private JoinWindows(long beforeMs, long afterMs, long graceMs, boolean enableSpuriousResultFix) {
        if (beforeMs + afterMs < 0L) {
            throw new IllegalArgumentException("Window interval (ie, beforeMs+afterMs) must not be negative.");
        }
        if (graceMs < 0L) {
            throw new IllegalArgumentException("Grace period must not be negative.");
        }
        this.afterMs = afterMs;
        this.beforeMs = beforeMs;
        this.graceMs = graceMs;
        this.enableSpuriousResultFix = enableSpuriousResultFix;
    }

    public static JoinWindows ofTimeDifferenceAndGrace(Duration timeDifference, Duration afterWindowEnd) {
        String timeDifferenceMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        long timeDifferenceMs = ApiUtils.validateMillisecondDuration(timeDifference, timeDifferenceMsgPrefix);
        String afterWindowEndMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, afterWindowEndMsgPrefix);
        return new JoinWindows(timeDifferenceMs, timeDifferenceMs, afterWindowEndMs, true);
    }

    public static JoinWindows ofTimeDifferenceWithNoGrace(Duration timeDifference) {
        return JoinWindows.ofTimeDifferenceAndGrace(timeDifference, Duration.ofMillis(0L));
    }

    @Deprecated
    public static JoinWindows of(Duration timeDifference) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        long timeDifferenceMs = ApiUtils.validateMillisecondDuration(timeDifference, msgPrefix);
        return new JoinWindows(timeDifferenceMs, timeDifferenceMs, Math.max(86400000L - timeDifferenceMs * 2L, 0L), false);
    }

    public JoinWindows before(Duration timeDifference) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        long timeDifferenceMs = ApiUtils.validateMillisecondDuration(timeDifference, msgPrefix);
        return new JoinWindows(timeDifferenceMs, this.afterMs, this.graceMs, this.enableSpuriousResultFix);
    }

    public JoinWindows after(Duration timeDifference) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(timeDifference, "timeDifference");
        long timeDifferenceMs = ApiUtils.validateMillisecondDuration(timeDifference, msgPrefix);
        return new JoinWindows(this.beforeMs, timeDifferenceMs, this.graceMs, this.enableSpuriousResultFix);
    }

    @Override
    public Map<Long, Window> windowsFor(long timestamp) {
        throw new UnsupportedOperationException("windowsFor() is not supported by JoinWindows.");
    }

    @Override
    public long size() {
        return this.beforeMs + this.afterMs;
    }

    @Deprecated
    public JoinWindows grace(Duration afterWindowEnd) throws IllegalArgumentException {
        if (this.enableSpuriousResultFix) {
            throw new IllegalStateException("Cannot call grace() after setting grace value via ofTimeDifferenceAndGrace or ofTimeDifferenceWithNoGrace.");
        }
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, msgPrefix);
        return new JoinWindows(this.beforeMs, this.afterMs, afterWindowEndMs, false);
    }

    @Override
    public long gracePeriodMs() {
        return this.graceMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinWindows that = (JoinWindows)o;
        return this.beforeMs == that.beforeMs && this.afterMs == that.afterMs && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.beforeMs, this.afterMs, this.graceMs);
    }

    public String toString() {
        return "JoinWindows{beforeMs=" + this.beforeMs + ", afterMs=" + this.afterMs + ", graceMs=" + this.graceMs + '}';
    }
}

