/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.ConstrainedPrioritySet;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignmentUtils;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStandbyTaskAssignor
implements StandbyTaskAssignor {
    private static final Logger log = LoggerFactory.getLogger(DefaultStandbyTaskAssignor.class);

    DefaultStandbyTaskAssignor() {
    }

    @Override
    public boolean assign(Map<UUID, ClientState> clients, Set<TaskId> allTaskIds, Set<TaskId> statefulTaskIds, AssignorConfiguration.AssignmentConfigs configs) {
        int numStandbyReplicas = configs.numStandbyReplicas;
        Map<TaskId, Integer> tasksToRemainingStandbys = StandbyTaskAssignmentUtils.computeTasksToRemainingStandbys(numStandbyReplicas, statefulTaskIds);
        ConstrainedPrioritySet standbyTaskClientsByTaskLoad = StandbyTaskAssignmentUtils.createLeastLoadedPrioritySetConstrainedByAssignedTask(clients);
        standbyTaskClientsByTaskLoad.offerAll(clients.keySet());
        for (TaskId task : statefulTaskIds) {
            StandbyTaskAssignmentUtils.pollClientAndMaybeAssignAndUpdateRemainingStandbyTasks(numStandbyReplicas, clients, tasksToRemainingStandbys, standbyTaskClientsByTaskLoad, task, log);
        }
        return false;
    }
}

