/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableSerializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSide;

public class TimestampedKeyAndJoinSideSerializer<K>
implements WrappingNullableSerializer<TimestampedKeyAndJoinSide<K>, K, Void> {
    private Serializer<K> keySerializer;
    private final Serializer<Long> timestampSerializer = new LongSerializer();

    TimestampedKeyAndJoinSideSerializer(Serializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.keySerializer == null) {
            this.keySerializer = getter.keySerde().serializer();
        }
        WrappingNullableUtils.initNullableSerializer(this.keySerializer, getter);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.keySerializer.configure(configs, isKey);
    }

    public byte[] serialize(String topic, TimestampedKeyAndJoinSide<K> data) {
        byte boolByte = (byte)(data.isLeftSide() ? 1 : 0);
        byte[] keyBytes = this.keySerializer.serialize(topic, data.getKey());
        byte[] timestampBytes = this.timestampSerializer.serialize(topic, (Object)data.getTimestamp());
        return ByteBuffer.allocate(timestampBytes.length + 1 + keyBytes.length).put(timestampBytes).put(boolByte).put(keyBytes).array();
    }

    public void close() {
        this.keySerializer.close();
    }
}

