/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingNearestChildrenKnnCollector;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class DiversifyingChildrenFloatKnnVectorQuery
extends KnnFloatVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final BitSetProducer parentsFilter;
    private final Query childFilter;
    private final int k;
    private final float[] query;

    public DiversifyingChildrenFloatKnnVectorQuery(String field, float[] query, Query childFilter, int k, BitSetProducer parentsFilter) {
        super(field, query, k, childFilter);
        this.childFilter = childFilter;
        this.parentsFilter = parentsFilter;
        this.k = k;
        this.query = query;
    }

    protected TopDocs exactSearch(LeafReaderContext context, DocIdSetIterator acceptIterator) throws IOException {
        FieldInfo fi = context.reader().getFieldInfos().fieldInfo(this.field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return NO_RESULTS;
        }
        if (fi.getVectorEncoding() != VectorEncoding.FLOAT32) {
            return null;
        }
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return NO_RESULTS;
        }
        DiversifyingChildrenFloatVectorScorer vectorScorer = new DiversifyingChildrenFloatVectorScorer(context.reader().getFloatVectorValues(this.field), acceptIterator, parentBitSet, this.query, fi.getVectorSimilarityFunction());
        HitQueue queue = new HitQueue(this.k, true);
        ScoreDoc topDoc = (ScoreDoc)queue.top();
        while (vectorScorer.nextParent() != Integer.MAX_VALUE) {
            float score = vectorScorer.score();
            if (!(score > topDoc.score)) continue;
            topDoc.score = score;
            topDoc.doc = vectorScorer.bestChild();
            topDoc = (ScoreDoc)queue.updateTop();
        }
        while (queue.size() > 0 && ((ScoreDoc)queue.top()).score < 0.0f) {
            queue.pop();
        }
        ScoreDoc[] topScoreDocs = new ScoreDoc[queue.size()];
        for (int i = topScoreDocs.length - 1; i >= 0; --i) {
            topScoreDocs[i] = (ScoreDoc)queue.pop();
        }
        TotalHits totalHits = new TotalHits(acceptIterator.cost(), TotalHits.Relation.EQUAL_TO);
        return new TopDocs(totalHits, topScoreDocs);
    }

    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit) throws IOException {
        BitSet parentBitSet = this.parentsFilter.getBitSet(context);
        if (parentBitSet == null) {
            return NO_RESULTS;
        }
        DiversifyingNearestChildrenKnnCollector collector = new DiversifyingNearestChildrenKnnCollector(this.k, visitedLimit, parentBitSet);
        context.reader().searchNearestVectors(this.field, this.query, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    public String toString(String field) {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.field + "[" + this.query[0] + ",...][" + this.k + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DiversifyingChildrenFloatKnnVectorQuery that = (DiversifyingChildrenFloatKnnVectorQuery)((Object)o);
        return this.k == that.k && Objects.equals(this.parentsFilter, that.parentsFilter) && Objects.equals(this.childFilter, that.childFilter) && Arrays.equals(this.query, that.query);
    }

    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.parentsFilter, this.childFilter, this.k);
        result = 31 * result + Arrays.hashCode(this.query);
        return result;
    }

    private static class DiversifyingChildrenFloatVectorScorer {
        private final float[] query;
        private final FloatVectorValues values;
        private final VectorSimilarityFunction similarity;
        private final DocIdSetIterator acceptedChildrenIterator;
        private final BitSet parentBitSet;
        private int currentParent = -1;
        private int bestChild = -1;
        private float currentScore = Float.NEGATIVE_INFINITY;

        protected DiversifyingChildrenFloatVectorScorer(FloatVectorValues values, DocIdSetIterator acceptedChildrenIterator, BitSet parentBitSet, float[] query, VectorSimilarityFunction similarity) {
            this.query = query;
            this.values = values;
            this.similarity = similarity;
            this.acceptedChildrenIterator = acceptedChildrenIterator;
            this.parentBitSet = parentBitSet;
        }

        public int bestChild() {
            return this.bestChild;
        }

        public int nextParent() throws IOException {
            int nextChild = this.acceptedChildrenIterator.docID();
            if (nextChild == -1) {
                nextChild = this.acceptedChildrenIterator.nextDoc();
            }
            if (nextChild == Integer.MAX_VALUE) {
                this.currentParent = Integer.MAX_VALUE;
                return this.currentParent;
            }
            this.currentScore = Float.NEGATIVE_INFINITY;
            this.currentParent = this.parentBitSet.nextSetBit(nextChild);
            do {
                this.values.advance(nextChild);
                float score = this.similarity.compare(this.query, this.values.vectorValue());
                if (!(score > this.currentScore)) continue;
                this.bestChild = nextChild;
                this.currentScore = score;
            } while ((nextChild = this.acceptedChildrenIterator.nextDoc()) != Integer.MAX_VALUE && nextChild < this.currentParent);
            return this.currentParent;
        }

        public float score() throws IOException {
            return this.currentScore;
        }
    }
}

