/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr.util;

import java.util.Collections;
import java.util.Vector;
import org.apache.maven.jxr.util.StringEntry;

public class SimpleWordTokenizer {
    public static final char[] BREAKERS = new char[]{'(', ')', '[', ' ', '{', '}'};

    public static StringEntry[] tokenize(String line) {
        int start = SimpleWordTokenizer.getStart(line);
        if (line == null || line.length() == 0 || start == -1) {
            return new StringEntry[0];
        }
        return SimpleWordTokenizer.tokenize(line, start);
    }

    public static StringEntry[] tokenize(String line, String find) {
        Vector<StringEntry> v = new Vector<StringEntry>();
        StringEntry[] se = SimpleWordTokenizer.tokenize(line);
        for (int i = 0; i < se.length; ++i) {
            if (!se[i].toString().equals(find)) continue;
            v.addElement(se[i]);
        }
        Object[] found = new StringEntry[v.size()];
        Collections.sort(v);
        v.copyInto(found);
        return found;
    }

    private static StringEntry[] tokenize(String line, int start) {
        int next;
        Vector<StringEntry> words = new Vector<StringEntry>();
        while ((next = SimpleWordTokenizer.getNextBreak(line, start)) >= 0 && next > start) {
            String word = line.substring(start, next);
            if (SimpleWordTokenizer.isWord(word)) {
                words.addElement(new StringEntry(word, start));
            }
            start = next + 1;
        }
        Object[] found = new StringEntry[words.size()];
        words.copyInto(found);
        return found;
    }

    private static boolean isWord(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    private static int getNextBreak(String string, int start) {
        int breakPoint = -1;
        for (int i = 0; i < BREAKERS.length; ++i) {
            int next = string.indexOf(BREAKERS[i], start);
            if (breakPoint != -1 && (next >= breakPoint || next == -1)) continue;
            breakPoint = next;
        }
        if (breakPoint == -1) {
            breakPoint = string.length();
        }
        return breakPoint;
    }

    private static int getStart(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (SimpleWordTokenizer.isBreaker(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBreaker(char c) {
        for (int i = 0; i < BREAKERS.length; ++i) {
            if (BREAKERS[i] != c) continue;
            return true;
        }
        return false;
    }
}

