/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ejb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-ejb-plugin:2.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven EJB Plugin 2.2", 0);
        this.append(sb, "Generates a J2EE Enterprise JavaBean (EJB) file as well as the associated client JAR.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "ejb".equals(this.goal)) {
            this.append(sb, "ejb:ejb", 0);
            this.append(sb, "Build an EJB (and optional client) from the current project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference. This version of the EJB Plugin uses Maven Archiver 2.4.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clientExcludes", 2);
                this.append(sb, "The files and directories to exclude from the client jar. Usage:\n<clientExcludes>\n\u00a0\u00a0<clientExclude>**/*Ejb.class</clientExclude>\n\u00a0\u00a0<clientExclude>**/*Bean.class</clientExclude>\n</clientExcludes>\n\nAttribute is used only if client jar is generated.\nDefault exclusions: **/*Bean.class, **/*CMP.class, **/*Session.class, **/package.html", 3);
                this.append(sb, "", 0);
                this.append(sb, "clientIncludes", 2);
                this.append(sb, "The files and directories to include in the client jar. Usage:\n<clientIncludes>\n\u00a0\u00a0<clientInclude>**/*</clientInclude>\n</clientIncludes>\n\nAttribute is used only if client jar is generated.\nDefault value: **/**", 3);
                this.append(sb, "", 0);
                this.append(sb, "ejbVersion (Default: 2.1)", 2);
                this.append(sb, "What EJB version should the EJB Plugin generate? Valid values are '2.x' or '3.x' (where x is a digit). When ejbVersion is '3.x', the ejb-jar.xml file is optional.\n>Usage:\n\n<ejbVersion>3.0</ejbVersion>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The files and directories to exclude from the main EJB jar. Usage:\n<excludes>\n<exclude>**/*Ejb.class</exclude>\n<exclude>**/*Bean.class</exclude>\n</excludes>\n\nDefault exclusions: META-INF/ejb-jar.xml, **/package.html", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateClient (Default: false)", 2);
                this.append(sb, "Whether the EJB client jar should be generated or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jarName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the EJB file to generate.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Directory that resources are copied to during the build.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "ejb:help", 0);
            this.append(sb, "Display help information on maven-ejb-plugin.\nCall\n\u00a0\u00a0mvn\u00a0ejb:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

