/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.codehaus.plexus.util.IOUtil;

class FileLogger
implements InvocationOutputHandler {
    private File file;
    private PrintStream stream;
    private boolean shouldFinalize = true;
    private final Log log;

    public FileLogger(File outputFile) throws IOException {
        this(outputFile, null);
    }

    public FileLogger(File outputFile, Log log) throws IOException {
        this.file = outputFile;
        this.log = log;
        outputFile.getParentFile().mkdirs();
        this.stream = new PrintStream(new FileOutputStream(outputFile));
        Runnable finalizer = new Runnable(){

            public void run() {
                try {
                    this.finalize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(finalizer));
    }

    public File getOutputFile() {
        return this.file;
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    public void consumeLine(String line) {
        this.stream.println(line);
        this.stream.flush();
        if (this.log != null) {
            this.log.info((CharSequence)line);
        }
    }

    public void close() {
        if (this.stream != null) {
            this.stream.flush();
        }
        IOUtil.close((OutputStream)this.stream);
    }

    protected void finalize() {
        if (this.shouldFinalize) {
            this.close();
        }
    }
}

