/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc.resolver;

import java.io.File;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;

public class SourceResolverConfig {
    private ProjectBuildingRequest buildingRequest;
    private final MavenProject project;
    private AndFilter filter;
    private List<MavenProject> reactorProjects;
    private final File outputBasedir;
    private boolean compileSourceIncluded;
    private boolean testSourceIncluded;

    public SourceResolverConfig(MavenProject project, ProjectBuildingRequest buildingRequest, File outputBasedir) {
        this.project = project;
        this.buildingRequest = buildingRequest;
        this.outputBasedir = outputBasedir;
    }

    public SourceResolverConfig withFilter(AndFilter filter) {
        this.filter = filter;
        return this;
    }

    public SourceResolverConfig withReactorProjects(List<MavenProject> reactorProjects) {
        this.reactorProjects = reactorProjects;
        return this;
    }

    public SourceResolverConfig withCompileSources() {
        this.compileSourceIncluded = true;
        return this;
    }

    public SourceResolverConfig withoutCompileSources() {
        this.compileSourceIncluded = false;
        return this;
    }

    public SourceResolverConfig withTestSources() {
        this.testSourceIncluded = true;
        return this;
    }

    public SourceResolverConfig withoutTestSources() {
        this.testSourceIncluded = false;
        return this;
    }

    public MavenProject project() {
        return this.project;
    }

    public ProjectBuildingRequest getBuildingRequest() {
        return this.buildingRequest;
    }

    public AndFilter filter() {
        return this.filter;
    }

    public List<MavenProject> reactorProjects() {
        return this.reactorProjects;
    }

    public File outputBasedir() {
        return this.outputBasedir;
    }

    public boolean includeCompileSources() {
        return this.compileSourceIncluded;
    }

    public boolean includeTestSources() {
        return this.testSourceIncluded;
    }
}

