/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jmod;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJModMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter
    private Map<String, String> jdkToolchain;

    protected String getJModExecutable() throws IOException {
        Toolchain tc = this.getToolchain();
        String jModExecutable = null;
        if (tc != null) {
            jModExecutable = tc.findTool("jmod");
        }
        String jModCommand = "jmod" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)jModExecutable)) {
            File jModExe = new File(jModExecutable);
            if (jModExe.isDirectory()) {
                jModExe = new File(jModExe, jModCommand);
            }
            if (SystemUtils.IS_OS_WINDOWS && jModExe.getName().indexOf(46) < 0) {
                jModExe = new File(jModExe.getPath() + ".exe");
            }
            if (!jModExe.isFile()) {
                throw new IOException("The jmod executable '" + jModExe + "' doesn't exist or is not a file.");
            }
            return jModExe.getAbsolutePath();
        }
        File jModExe = new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "bin", jModCommand);
        if (!jModExe.exists() || !jModExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).getCanonicalFile().exists() || new File(javaHome).getCanonicalFile().isFile()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            jModExe = new File(javaHome + File.separator + "bin", jModCommand);
        }
        if (!jModExe.getCanonicalFile().exists() || !jModExe.getCanonicalFile().isFile()) {
            throw new IOException("The jmod executable '" + jModExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return jModExe.getAbsolutePath();
    }

    protected boolean projectHasAlreadySetAnArtifact() {
        if (this.getProject().getArtifact().getFile() != null) {
            return this.getProject().getArtifact().getFile().isFile();
        }
        return false;
    }

    protected void executeCommand(Commandline cmd, File outputDirectory) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", ""));
        }
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (exitCode != 0) {
                if (StringUtils.isNotEmpty(output)) {
                    this.getLog().info((CharSequence)output);
                }
                StringBuilder msg = new StringBuilder("\nExit code: ");
                msg.append(exitCode);
                if (StringUtils.isNotEmpty((String)err.getOutput())) {
                    msg.append(" - ").append(err.getOutput());
                }
                msg.append('\n');
                msg.append("Command line was: ").append(cmd).append('\n').append('\n');
                throw new MojoExecutionException(msg.toString());
            }
            if (StringUtils.isNotEmpty(output)) {
                String[] splitLines;
                for (String outputLine : splitLines = StringUtils.split((String)output, (String)"\n")) {
                    this.getLog().info((CharSequence)outputLine);
                }
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute jmod command: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String getCommaSeparatedList(List<String> modules) {
        StringBuilder sb = new StringBuilder();
        for (String module : modules) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(module);
        }
        return sb.toString();
    }

    protected Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.jdkToolchain != null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", this.jdkToolchain);
                if (tcs != null && tcs.size() > 0) {
                    tc = (Toolchain)tcs.get(0);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }
}

