/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.AttributeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.AbstractDocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Writer;
import org.apache.maven.doxia.index.IndexEntry;
import org.apache.maven.doxia.index.IndexingSink;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.SinkAdapter;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.pdf.DocumentDescriptorReader;
import org.apache.maven.plugins.pdf.DocumentModelBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PdfMojo
extends AbstractMojo {
    private static final String EOL = System.getProperty("line.separator");
    private PdfRenderer foRenderer;
    private I18N i18n;
    private PdfRenderer itextRenderer;
    private String locales;
    private Renderer siteRenderer;
    private SiteTool siteTool;
    private PluginManager pluginManager;
    private Doxia doxia;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder mavenProjectBuilder;
    private MavenProject project;
    private Settings settings;
    private MavenSession session;
    private File siteDirectory;
    private File generatedSiteDirectory;
    private File outputDirectory;
    private File workingDirectory;
    private File docDescriptor;
    private String implementation;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private boolean aggregate;
    private String pluginVersion;
    private boolean includeReports;
    private String generateTOC;
    private DocumentRenderer docRenderer;
    private Locale defaultLocale;
    private List localesList;
    private DecorationModel defaultDecorationModel;
    private File siteDirectoryTmp;
    private File generatedSiteDirectoryTmp;
    private Map generatedMavenReports;
    static /* synthetic */ Class class$javax$swing$text$AttributeSet;
    static /* synthetic */ Class class$org$apache$maven$doxia$sink$SinkEventAttributes;
    static /* synthetic */ Class class$org$apache$maven$doxia$sink$Sink;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        try {
            this.generatedPdf();
        }
        catch (IOException e) {
            this.debugLogGeneratedModel(this.getDocumentModel(Locale.ENGLISH));
            throw new MojoExecutionException("Error during document generation: " + e.getMessage(), (Exception)e);
        }
        try {
            this.copyGeneratedPdf();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated PDF: " + e.getMessage(), (Exception)e);
        }
    }

    private void init() throws MojoFailureException {
        if ("fo".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.foRenderer;
        } else if ("itext".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.itextRenderer;
        } else {
            throw new MojoFailureException("Not a valid 'implementation' parameter: '" + this.implementation + "'. Should be 'fo' or 'itext'.");
        }
        if (!("none".equalsIgnoreCase(this.generateTOC) || "start".equalsIgnoreCase(this.generateTOC) || "end".equalsIgnoreCase(this.generateTOC))) {
            throw new MojoFailureException("Not a valid 'generateTOC' parameter: '" + this.generateTOC + "'. Should be 'none', 'start' or 'end'.");
        }
    }

    private void copyGeneratedPdf() throws MojoExecutionException, IOException {
        if (!this.outputDirectory.getCanonicalPath().equals(this.workingDirectory.getCanonicalPath())) {
            String outputName = this.getDocumentModel(this.getDefaultLocale()).getOutputName();
            String extension = FileUtils.getExtension((String)outputName);
            if (StringUtils.isNotEmpty((String)extension)) {
                outputName = outputName.substring(0, outputName.indexOf(extension) - 1);
            }
            Iterator iterator = this.getAvailableLocales().iterator();
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                File generatedPdfSource = !locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) ? new File(this.workingDirectory, locale.getLanguage() + File.separator + outputName + ".pdf") : new File(this.workingDirectory, outputName + ".pdf");
                if (!generatedPdfSource.exists()) {
                    this.getLog().warn((CharSequence)("Unable to find the generated pdf: " + generatedPdfSource.getAbsolutePath()));
                    continue;
                }
                File generatedPdfDest = !locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) ? new File(this.outputDirectory, locale.getLanguage() + File.separator + outputName + ".pdf") : new File(this.outputDirectory, outputName + ".pdf");
                FileUtils.copyFile((File)generatedPdfSource, (File)generatedPdfDest);
                generatedPdfSource.delete();
            }
        }
    }

    private void generatedPdf() throws MojoExecutionException, IOException {
        try {
            FileUtils.deleteDirectory((File)this.workingDirectory);
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
            }
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
        }
        Locale.setDefault(this.getDefaultLocale());
        Iterator iterator = this.getAvailableLocales().iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            File workingDir = this.getWorkingDirectory(locale);
            File siteDirectoryFile = this.getSiteDirectoryTmp();
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                siteDirectoryFile = new File(this.getSiteDirectoryTmp(), locale.getLanguage());
            }
            this.copyResources(locale);
            this.generateMavenReports(locale);
            DocumentRendererContext context = new DocumentRendererContext();
            context.put("project", (Object)this.project);
            context.put("settings", (Object)this.settings);
            context.put("PathTool", (Object)new PathTool());
            context.put("FileUtils", (Object)new FileUtils());
            context.put("StringUtils", (Object)new StringUtils());
            context.put("i18n", (Object)this.i18n);
            context.put("generateTOC", (Object)this.generateTOC);
            try {
                if (this.aggregate) {
                    ((AbstractDocumentRenderer)this.docRenderer).render(siteDirectoryFile, workingDir, this.getDocumentModel(locale), context);
                    continue;
                }
                ((AbstractDocumentRenderer)this.docRenderer).render(siteDirectoryFile, workingDir, null, context);
            }
            catch (DocumentRendererException e) {
                if (this.getLog().isDebugEnabled()) {
                    throw new MojoExecutionException("Error during document generation: " + e.getMessage(), (Exception)((Object)e));
                }
                throw new MojoExecutionException("Error during document generation: " + e.getMessage());
            }
        }
    }

    private File getSiteDirectoryTmp() throws IOException {
        if (this.siteDirectoryTmp == null) {
            File tmpSiteDir = new File(this.workingDirectory, "site.tmp");
            this.prepareTempSiteDirectory(tmpSiteDir);
            this.siteDirectoryTmp = tmpSiteDir;
        }
        return this.siteDirectoryTmp;
    }

    private File getGeneratedSiteDirectoryTmp() {
        if (this.generatedSiteDirectoryTmp == null) {
            this.generatedSiteDirectoryTmp = new File(this.workingDirectory, "generated-site.tmp");
        }
        return this.generatedSiteDirectoryTmp;
    }

    private void prepareTempSiteDirectory(File tmpSiteDir) throws IOException {
        tmpSiteDir.mkdirs();
        FileUtils.copyDirectoryStructure((File)this.siteDirectory, (File)tmpSiteDir);
        List files = FileUtils.getFileAndDirectoryNames((File)tmpSiteDir, (String)FileUtils.getDefaultExcludesAsString(), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File file = new File(it.next().toString());
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
                continue;
            }
            file.delete();
        }
        this.copySiteDir(this.generatedSiteDirectory, tmpSiteDir);
    }

    private void copySiteDir(File from, File to) throws IOException {
        if (from == null || !from.exists()) {
            return;
        }
        Iterator iterator = this.getAvailableLocales().iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
            List siteFiles = FileUtils.getFileNames((File)this.siteDirectory, (String)"**/*", (String)excludes, (boolean)false);
            File siteDirectoryLocale = new File(this.siteDirectory, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && siteDirectoryLocale.exists()) {
                siteFiles = FileUtils.getFileNames((File)siteDirectoryLocale, (String)"**/*", (String)excludes, (boolean)false);
            }
            List generatedSiteFiles = FileUtils.getFileNames((File)from, (String)"**/*", (String)excludes, (boolean)false);
            File fromLocale = new File(from, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && fromLocale.exists()) {
                generatedSiteFiles = FileUtils.getFileNames((File)fromLocale, (String)"**/*", (String)excludes, (boolean)false);
            }
            Iterator it = generatedSiteFiles.iterator();
            while (it.hasNext()) {
                File out;
                File in;
                String generatedSiteFile = it.next().toString();
                if (siteFiles.contains(generatedSiteFile)) {
                    this.getLog().warn((CharSequence)("Generated-site already contains a file in site: " + generatedSiteFile + ". Ignoring copying it!"));
                    continue;
                }
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    if (!fromLocale.exists()) continue;
                    in = new File(fromLocale, generatedSiteFile);
                    out = new File(new File(to, locale.getLanguage()), generatedSiteFile);
                    out.getParentFile().mkdirs();
                    FileUtils.copyFile((File)in, (File)out);
                    continue;
                }
                in = new File(from, generatedSiteFile);
                out = new File(to, generatedSiteFile);
                out.getParentFile().mkdirs();
                FileUtils.copyFile((File)in, (File)out);
            }
        }
    }

    private DocumentModel getDocumentModel(Locale locale) throws MojoExecutionException {
        if (this.docDescriptor.exists()) {
            DocumentModel doc = this.getDocumentModelFromDescriptor(locale);
            this.appendGeneratedReports(doc, locale);
            return doc;
        }
        DocumentModel model = new DocumentModelBuilder(this.project, this.getDefaultDecorationModel()).getDocumentModel();
        model.getMeta().setGenerator(this.getDefaultGenerator());
        model.getMeta().setLanguage(locale.getLanguage());
        model.getCover().setCoverType(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.type"));
        model.getToc().setName(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.title"));
        this.appendGeneratedReports(model, locale);
        this.debugLogGeneratedModel(model);
        return model;
    }

    private DocumentModel getDocumentModelFromDescriptor(Locale locale) throws MojoExecutionException {
        DocumentModel model = null;
        try {
            model = new DocumentDescriptorReader(this.project, this.getLog()).readAndFilterDocumentDescriptor(this.docDescriptor);
        }
        catch (XmlPullParserException ex) {
            throw new MojoExecutionException("Error reading DocumentDescriptor!", (Exception)((Object)ex));
        }
        catch (IOException io) {
            throw new MojoExecutionException("Error opening DocumentDescriptor!", (Exception)io);
        }
        if (StringUtils.isEmpty((String)model.getMeta().getLanguage())) {
            model.getMeta().setLanguage(locale.getLanguage());
        }
        if (StringUtils.isEmpty((String)model.getMeta().getGenerator())) {
            model.getMeta().setGenerator(this.getDefaultGenerator());
        }
        return model;
    }

    private File getWorkingDirectory(Locale locale) {
        if (locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
            return this.workingDirectory;
        }
        return new File(this.workingDirectory, locale.getLanguage());
    }

    private Locale getDefaultLocale() {
        if (this.defaultLocale == null) {
            this.defaultLocale = (Locale)this.getAvailableLocales().get(0);
        }
        return this.defaultLocale;
    }

    private List getAvailableLocales() {
        if (this.localesList == null) {
            this.localesList = this.siteTool.getAvailableLocales(this.locales);
        }
        return this.localesList;
    }

    private DecorationModel getDefaultDecorationModel() throws MojoExecutionException {
        if (this.defaultDecorationModel == null) {
            Locale locale = this.getDefaultLocale();
            File basedir = this.project.getBasedir();
            String relativePath = this.siteTool.getRelativePath(this.siteDirectory.getAbsolutePath(), basedir.getAbsolutePath());
            File descriptorFile = this.siteTool.getSiteDescriptorFromBasedir(relativePath, basedir, locale);
            DecorationModel decoration = null;
            if (descriptorFile.exists()) {
                XmlStreamReader reader = null;
                try {
                    reader = ReaderFactory.newXmlReader((File)descriptorFile);
                    String enc = reader.getEncoding();
                    String siteDescriptorContent = IOUtil.toString((Reader)reader);
                    siteDescriptorContent = this.siteTool.getInterpolatedSiteDescriptorContent(new HashMap(), this.project, siteDescriptorContent, enc, enc);
                    decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading site descriptor", (Exception)e);
                }
                catch (SiteToolException e) {
                    throw new MojoExecutionException("Error when interpoling site descriptor", (Exception)((Object)e));
                }
                finally {
                    IOUtil.close((Reader)reader);
                }
            }
            this.defaultDecorationModel = decoration;
        }
        return this.defaultDecorationModel;
    }

    private void copyResources(Locale locale) throws MojoExecutionException {
        File skinFile;
        DecorationModel decorationModel = this.getDefaultDecorationModel();
        if (decorationModel == null) {
            return;
        }
        try {
            skinFile = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.project.getRemoteArtifactRepositories(), decorationModel).getFile();
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (skinFile == null) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Copy resources from skin artifact: '" + skinFile + "'..."));
        }
        try {
            SiteRenderingContext context = this.siteRenderer.createContextForSkin(skinFile, new HashMap(), decorationModel, this.project.getName(), locale);
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            Iterator i = context.getSiteDirectories().iterator();
            while (i.hasNext()) {
                File siteDirectoryFile = (File)i.next();
                this.siteRenderer.copyResources(context, new File(siteDirectoryFile, "resources"), this.workingDirectory);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
    }

    private String getDefaultGenerator() {
        return "Maven PDF Plugin v. " + this.pluginVersion + ", '" + this.implementation + "' implementation.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugLogGeneratedModel(DocumentModel docModel) {
        if (this.getLog().isDebugEnabled() && this.project != null) {
            File outputDir = new File(this.project.getBuild().getDirectory(), "pdf");
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File doc = FileUtils.createTempFile((String)"pdf", (String)".xml", (File)outputDir);
            DocumentXpp3Writer xpp3 = new DocumentXpp3Writer();
            XmlStreamWriter w = null;
            try {
                w = WriterFactory.newXmlWriter((File)doc);
                xpp3.write((Writer)w, docModel);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Generated a default document model: " + doc.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)("Failed to write document model: " + e.getMessage()), (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)("Failed to write document model: " + e.getMessage()));
                }
            }
            finally {
                IOUtil.close((Writer)w);
            }
        }
    }

    private void generateMavenReports(Locale locale) throws MojoExecutionException, IOException {
        if (!this.includeReports) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Skipped report generation.");
            }
            return;
        }
        if (this.project.getReporting() == null) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"No report was specified.");
            }
            return;
        }
        Iterator it = this.project.getReporting().getPlugins().iterator();
        while (it.hasNext()) {
            ReportPlugin reportPlugin = (ReportPlugin)it.next();
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(reportPlugin);
            ArrayList<String> goals = new ArrayList<String>();
            Iterator it2 = reportPlugin.getReportSets().iterator();
            while (it2.hasNext()) {
                ReportSet reportSet = (ReportSet)it2.next();
                Iterator it3 = reportSet.getReports().iterator();
                while (it3.hasNext()) {
                    goals.add(it3.next().toString());
                }
            }
            List mojoDescriptors = pluginDescriptor.getMojos();
            Iterator it22 = mojoDescriptors.iterator();
            while (it22.hasNext()) {
                MojoDescriptor mojoDescriptor = (MojoDescriptor)it22.next();
                if (!goals.isEmpty() && (goals.isEmpty() || !goals.contains(mojoDescriptor.getGoal()))) continue;
                MavenReport report = this.getMavenReport(mojoDescriptor);
                this.generateMavenReport(mojoDescriptor, report, locale);
            }
        }
        if (!this.getGeneratedMavenReports(locale).isEmpty()) {
            File outDir = new File(this.getGeneratedSiteDirectoryTmp(), "xdoc");
            if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
                outDir = new File(new File(this.getGeneratedSiteDirectoryTmp(), locale.getLanguage()), "xdoc");
            }
            outDir.mkdirs();
            File piReport = new File(outDir, "project-info.xml");
            StringWriter sw = new StringWriter();
            PdfSink sink = new PdfSink(sw);
            ProjectInfoRenderer r = new ProjectInfoRenderer((org.apache.maven.doxia.sink.Sink)((Object)sink), this.getGeneratedMavenReports(locale), this.i18n, locale);
            r.render();
            PdfMojo.writeGeneratedReport(sw.toString(), piReport);
        }
        this.copySiteDir(this.getGeneratedSiteDirectoryTmp(), this.getSiteDirectoryTmp());
        this.copySiteDir(this.generatedSiteDirectory, this.getSiteDirectoryTmp());
    }

    private PluginDescriptor getPluginDescriptor(ReportPlugin reportPlugin) throws MojoExecutionException {
        try {
            return this.pluginManager.verifyReportPlugin(reportPlugin, this.project, this.session);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("ArtifactResolutionException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("ArtifactNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginNotFoundException e) {
            throw new MojoExecutionException("PluginNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginVersionResolutionException e) {
            throw new MojoExecutionException("PluginVersionResolutionException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("InvalidVersionSpecificationException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidPluginException e) {
            throw new MojoExecutionException("InvalidPluginException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginManagerException e) {
            throw new MojoExecutionException("PluginManagerException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginVersionNotFoundException e) {
            throw new MojoExecutionException("PluginVersionNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private MavenReport getMavenReport(MojoDescriptor mojoDescriptor) throws MojoExecutionException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mojoDescriptor.getPluginDescriptor().getClassRealm().getClassLoader());
            MojoExecution mojoExecution = new MojoExecution(mojoDescriptor);
            MavenReport mavenReport = this.pluginManager.getReport(this.project, mojoExecution, this.session);
            return mavenReport;
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("ArtifactNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("ArtifactResolutionException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginConfigurationException e) {
            throw new MojoExecutionException("PluginConfigurationException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginManagerException e) {
            throw new MojoExecutionException("PluginManagerException: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void generateMavenReport(MojoDescriptor mojoDescriptor, MavenReport report, Locale locale) throws IOException, MojoExecutionException {
        Object generatedReport;
        if (report == null) {
            return;
        }
        String localReportName = report.getName(locale);
        if (!report.canGenerateReport()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Skipped \"" + localReportName + "\" report."));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"canGenerateReport() was false.");
            }
            return;
        }
        if (report.isExternalReport()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Skipped external \"" + localReportName + "\" report."));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"isExternalReport() was false.");
            }
            return;
        }
        Iterator it = this.getGeneratedMavenReports(locale).iterator();
        while (it.hasNext()) {
            generatedReport = (MavenReport)it.next();
            if (!report.getName(locale).equals(generatedReport.getName(locale))) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(report.getName(locale) + " was already generated."));
            }
            return;
        }
        File outDir = new File(this.getGeneratedSiteDirectoryTmp(), "xdoc");
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            outDir = new File(new File(this.getGeneratedSiteDirectoryTmp(), locale.getLanguage()), "xdoc");
        }
        outDir.mkdirs();
        generatedReport = new File(outDir, report.getOutputName() + ".xml");
        String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
        List files = FileUtils.getFileNames((File)this.siteDirectory, (String)("*/" + report.getOutputName() + ".*"), (String)excludes, (boolean)false);
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            files = FileUtils.getFileNames((File)new File(this.siteDirectory, locale.getLanguage()), (String)("*/" + report.getOutputName() + ".*"), (String)excludes, (boolean)false);
        }
        if (files.size() != 0) {
            String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report, file \"" + report.getOutputName() + "\" already exists for the " + displayLanguage + " version."));
            }
            return;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Generating \"" + localReportName + "\" report."));
        }
        StringWriter sw = new StringWriter();
        PdfSink sink = null;
        try {
            sink = new PdfSink(sw);
            Sink proxy = (Sink)Proxy.newProxyInstance(Sink.class.getClassLoader(), new Class[]{Sink.class}, (InvocationHandler)new SinkDelegate((org.apache.maven.doxia.sink.Sink)((Object)sink)));
            report.generate(proxy, locale);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("MavenReportException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (LinkageError e) {
            if (this.getLog().isErrorEnabled()) {
                ClassRealm reportPluginRealm = mojoDescriptor.getPluginDescriptor().getClassRealm();
                StringBuffer sb = new StringBuffer();
                sb.append(report.getClass().getName()).append("#generate(...) caused a linkage error (");
                sb.append(e.getClass().getName()).append(") and may be out-of-date. Check the realms:").append(EOL);
                sb.append("Maven Report Plugin realm = " + reportPluginRealm.getId()).append(EOL);
                for (int i = 0; i < reportPluginRealm.getConstituents().length; ++i) {
                    sb.append("urls[" + i + "] = " + reportPluginRealm.getConstituents()[i]);
                    if (i == reportPluginRealm.getConstituents().length - 1) continue;
                    sb.append(EOL);
                }
                this.getLog().error((CharSequence)sb.toString());
            }
            throw e;
        }
        finally {
            if (sink != null) {
                sink.close();
            }
        }
        PdfMojo.writeGeneratedReport(sw.toString(), (File)generatedReport);
        if (this.isValidGeneratedReport(mojoDescriptor, (File)generatedReport, localReportName)) {
            this.getGeneratedMavenReports(locale).add(report);
        }
    }

    private List getGeneratedMavenReports(Locale locale) {
        if (this.generatedMavenReports == null) {
            this.generatedMavenReports = new HashMap();
        }
        if (this.generatedMavenReports.get(locale) == null) {
            this.generatedMavenReports.put(locale, new ArrayList());
        }
        return (List)this.generatedMavenReports.get(locale);
    }

    private void appendGeneratedReports(DocumentModel model, Locale locale) {
        if (!this.includeReports) {
            return;
        }
        if (this.getGeneratedMavenReports(locale).isEmpty()) {
            return;
        }
        DocumentTOCItem documentTOCItem = new DocumentTOCItem();
        documentTOCItem.setName(this.i18n.getString("pdf-plugin", locale, "toc.project-info.item"));
        documentTOCItem.setRef("/project-info");
        ArrayList<String> addedRef = new ArrayList<String>();
        ArrayList<DocumentTOCItem> items = new ArrayList<DocumentTOCItem>();
        Iterator it = this.getGeneratedMavenReports(locale).iterator();
        while (it.hasNext()) {
            MavenReport report = (MavenReport)it.next();
            DocumentTOCItem reportItem = new DocumentTOCItem();
            reportItem.setName(report.getName(locale));
            reportItem.setRef("/" + report.getOutputName());
            items.add(reportItem);
            addedRef.add(report.getOutputName());
        }
        try {
            if (this.generatedSiteDirectory.exists()) {
                String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
                List generatedDirs = FileUtils.getDirectoryNames((File)this.generatedSiteDirectory, (String)"*", (String)excludes, (boolean)true);
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    generatedDirs = FileUtils.getFileNames((File)new File(this.generatedSiteDirectory, locale.getLanguage()), (String)"*", (String)excludes, (boolean)true);
                }
                Iterator it2 = generatedDirs.iterator();
                while (it2.hasNext()) {
                    String generatedDir = it2.next().toString();
                    List generatedFiles = FileUtils.getFileNames((File)new File(generatedDir), (String)"**.*", (String)excludes, (boolean)false);
                    Iterator it22 = generatedFiles.iterator();
                    while (it22.hasNext()) {
                        String title;
                        String generatedFile = it22.next().toString();
                        String ref = generatedFile.substring(0, generatedFile.lastIndexOf("."));
                        if (addedRef.contains(ref) || (title = this.getGeneratedDocumentTitle(new File(generatedDir, generatedFile))) == null) continue;
                        DocumentTOCItem reportItem = new DocumentTOCItem();
                        reportItem.setName(title);
                        reportItem.setRef("/" + ref);
                        items.add(reportItem);
                    }
                }
            }
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
            }
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
        }
        documentTOCItem.setItems(items);
        model.getToc().addItem(documentTOCItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGeneratedDocumentTitle(File f) throws IOException {
        IndexEntry entry = new IndexEntry("index");
        IndexingSink titleSink = new IndexingSink(entry);
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)f);
            this.doxia.parse((Reader)reader, f.getParentFile().getName(), (org.apache.maven.doxia.sink.Sink)titleSink);
        }
        catch (ParseException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("ParseException: " + e.getMessage()), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("ParseException: " + e.getMessage()));
            }
            String string = null;
            return string;
        }
        catch (ParserNotFoundException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()));
            }
            String string = null;
            return string;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return titleSink.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidGeneratedReport(MojoDescriptor mojoDescriptor, File generatedReport, String localReportName) {
        SinkAdapter sinkAdapter = new SinkAdapter();
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)generatedReport);
            this.doxia.parse((Reader)reader, generatedReport.getParentFile().getName(), (org.apache.maven.doxia.sink.Sink)sinkAdapter);
        }
        catch (ParseException e) {
            StringBuffer sb = new StringBuffer();
            sb.append(EOL).append(EOL);
            sb.append("Error when parsing the generated report: ").append(generatedReport.getAbsolutePath());
            sb.append(EOL);
            sb.append(e.getMessage());
            sb.append(EOL).append(EOL);
            sb.append("You could:").append(EOL);
            sb.append("  * exclude all reports using -DincludeReports=false").append(EOL);
            sb.append("  * remove the ");
            sb.append(mojoDescriptor.getPluginDescriptor().getGroupId());
            sb.append(":");
            sb.append(mojoDescriptor.getPluginDescriptor().getArtifactId());
            sb.append(":");
            sb.append(mojoDescriptor.getPluginDescriptor().getVersion());
            sb.append(" from the <reporting/> part. To not affect the site generation, ");
            sb.append("you could create a PDF profile.").append(EOL);
            sb.append(EOL);
            MavenProject pluginProject = this.getReportPluginProject(mojoDescriptor.getPluginDescriptor());
            if (pluginProject == null) {
                sb.append("You could also contact the Plugin team.").append(EOL);
            } else {
                sb.append("You could also contact the Plugin team:").append(EOL);
                if (pluginProject.getMailingLists() != null && pluginProject.getMailingLists().size() != 0) {
                    boolean appended = false;
                    Iterator i = pluginProject.getMailingLists().iterator();
                    while (i.hasNext()) {
                        MailingList mailingList = (MailingList)i.next();
                        if (!StringUtils.isNotEmpty((String)mailingList.getName()) || !StringUtils.isNotEmpty((String)mailingList.getPost())) continue;
                        if (!appended) {
                            sb.append("  Mailing Lists:").append(EOL);
                            appended = true;
                        }
                        sb.append("    ").append(mailingList.getName());
                        sb.append(": ").append(mailingList.getPost());
                        sb.append(EOL);
                    }
                }
                if (StringUtils.isNotEmpty((String)pluginProject.getUrl())) {
                    sb.append("  Web Site:").append(EOL);
                    sb.append("    ").append(pluginProject.getUrl());
                    sb.append(EOL);
                }
                if (pluginProject.getIssueManagement() != null && StringUtils.isNotEmpty((String)pluginProject.getIssueManagement().getUrl())) {
                    sb.append("  Issue Tracking:").append(EOL);
                    sb.append("    ").append(pluginProject.getIssueManagement().getUrl());
                    sb.append(EOL);
                }
            }
            sb.append(EOL).append("Ignoring the \"" + localReportName + "\" report in the PDF.").append(EOL);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)sb.toString(), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)sb.toString());
            }
            boolean bl = false;
            return bl;
        }
        catch (ParserNotFoundException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()));
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return true;
    }

    private MavenProject getReportPluginProject(PluginDescriptor pluginDescriptor) {
        Artifact artifact = this.artifactFactory.createProjectArtifact(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), pluginDescriptor.getVersion(), "compile");
        try {
            return this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ProjectBuildingException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("ProjectBuildingException: " + e.getMessage()), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("ProjectBuildingException: " + e.getMessage()));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeGeneratedReport(String content, File toFile) throws IOException {
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        content = StringUtils.replace((String)content, (String)"<table><table", (String)"<table");
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)toFile);
            writer.write(content);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private static String getDefaultExcludesWithLocales(List locales, Locale defaultLocale) {
        String excludesLocales = FileUtils.getDefaultExcludesAsString();
        Iterator it = locales.iterator();
        while (it.hasNext()) {
            Locale locale = (Locale)it.next();
            if (locale.getLanguage().equals(defaultLocale.getLanguage())) continue;
            excludesLocales = excludesLocales + ",**/" + locale.getLanguage() + "/*";
        }
        return excludesLocales;
    }

    private static class SinkDelegate
    implements InvocationHandler {
        private final org.apache.maven.doxia.sink.Sink sink;

        public SinkDelegate(org.apache.maven.doxia.sink.Sink sink) {
            this.sink = sink;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int i;
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (i = parameterTypes.length - 1; i >= 0; --i) {
                if (!(class$javax$swing$text$AttributeSet == null ? PdfMojo.class$("javax.swing.text.AttributeSet") : class$javax$swing$text$AttributeSet).isAssignableFrom(parameterTypes[i])) continue;
                parameterTypes[i] = class$org$apache$maven$doxia$sink$SinkEventAttributes == null ? PdfMojo.class$("org.apache.maven.doxia.sink.SinkEventAttributes") : class$org$apache$maven$doxia$sink$SinkEventAttributes;
            }
            if (args != null) {
                for (i = args.length - 1; i >= 0; --i) {
                    if (!(class$javax$swing$text$AttributeSet == null ? PdfMojo.class$("javax.swing.text.AttributeSet") : class$javax$swing$text$AttributeSet).isInstance(args[i])) continue;
                    args[i] = new SinkEventAttributeSet((AttributeSet)args[i]);
                }
            }
            Method target = (class$org$apache$maven$doxia$sink$Sink == null ? (class$org$apache$maven$doxia$sink$Sink = PdfMojo.class$("org.apache.maven.doxia.sink.Sink")) : class$org$apache$maven$doxia$sink$Sink).getMethod(method.getName(), parameterTypes);
            return target.invoke((Object)this.sink, args);
        }
    }

    private static class ProjectInfoRenderer
    extends AbstractMavenReportRenderer {
        private final List generatedReports;
        private final I18N i18n;
        private final Locale locale;

        public ProjectInfoRenderer(org.apache.maven.doxia.sink.Sink sink, List generatedReports, I18N i18n, Locale locale) {
            super(sink);
            this.generatedReports = generatedReports;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("pdf-plugin", this.locale, "report.project-info.title");
        }

        public void renderBody() {
            this.sink.section1();
            this.sink.sectionTitle1();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.title"));
            this.sink.sectionTitle1_();
            this.sink.paragraph();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.description1") + " ");
            this.sink.link("http://maven.apache.org");
            this.sink.text("Maven");
            this.sink.link_();
            this.sink.text(" " + this.i18n.getString("pdf-plugin", this.locale, "report.project-info.description2"));
            this.sink.paragraph_();
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.sectionTitle"));
            this.sink.sectionTitle2_();
            this.sink.table();
            this.sink.tableRows(new int[]{1, 1}, false);
            String name = this.i18n.getString("pdf-plugin", this.locale, "report.project-info.column.document");
            String description = this.i18n.getString("pdf-plugin", this.locale, "report.project-info.column.description");
            this.sink.tableRow();
            this.sink.tableHeaderCell(SinkEventAttributeSet.CENTER);
            this.sink.text(name);
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell(SinkEventAttributeSet.CENTER);
            this.sink.text(description);
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            if (this.generatedReports != null) {
                Iterator it = this.generatedReports.iterator();
                while (it.hasNext()) {
                    MavenReport report = (MavenReport)it.next();
                    this.sink.tableRow();
                    this.sink.tableCell();
                    this.sink.link(report.getOutputName() + ".html");
                    this.sink.text(report.getName(this.locale));
                    this.sink.link_();
                    this.sink.tableCell_();
                    this.sink.tableCell();
                    this.sink.text(report.getDescription(this.locale));
                    this.sink.tableCell_();
                    this.sink.tableRow_();
                }
            }
            this.sink.tableRows_();
            this.sink.table_();
            this.sink.section2_();
            this.sink.section1_();
        }
    }

    private static class PdfSink
    extends XdocSink {
        protected PdfSink(Writer writer) {
            super(writer);
        }

        public void table() {
            super.table();
            this.writeStartTag(HtmlMarkup.TABLE);
        }

        public void text(String text) {
            super.write(StringUtils.replace((String)text, (String)"\u0092", (String)"'"));
        }
    }
}

