/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.kopitubruk.util.json.IndentPadding;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONParser;
import org.kopitubruk.util.json.JSONUtil;

class TocFileHelper {
    private static final String FILENAME = "toc.json";

    TocFileHelper() {
    }

    static void saveTOC(File workingDirectory, DocumentTOC toc, Locale locale) throws IOException {
        JSONConfig jsonConfig = new JSONConfig();
        jsonConfig.setIndentPadding(new IndentPadding("  ", "\n"));
        jsonConfig.addReflectClass(DocumentTOC.class);
        jsonConfig.addReflectClass(DocumentTOCItem.class);
        try (Writer writer = WriterFactory.newWriter((File)TocFileHelper.getTocFile(workingDirectory), (String)"UTF-8");){
            JSONUtil.toJSON((Object)toc, (JSONConfig)jsonConfig, (Writer)writer);
        }
    }

    static Map<String, Object> loadToc(File workingDirectory) throws IOException {
        try (Reader reader = ReaderFactory.newReader((File)TocFileHelper.getTocFile(workingDirectory), (String)"UTF-8");){
            Map map = (Map)JSONParser.parseJSON((Reader)reader);
            return map;
        }
    }

    private static File getTocFile(File workingDirectory) {
        return new File(workingDirectory, FILENAME);
    }
}

