/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.update;

import java.io.File;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.changelog.GitChangeLogCommand;
import org.apache.maven.scm.provider.git.gitexe.command.update.GitLatestRevisionCommandConsumer;
import org.apache.maven.scm.provider.git.gitexe.command.update.GitUpdateCommandConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitUpdateCommand
extends AbstractUpdateCommand
implements GitCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion scmVersion) throws ScmException {
        GitLatestRevisionCommandConsumer consumerRev;
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if ("file".equals(repository.getFetchInfo().getProtocol()) && repository.getFetchInfo().getPath().indexOf(fileSet.getBasedir().getPath()) >= 0) {
            throw new ScmException("remote repository must not be the working directory");
        }
        GitUpdateCommandConsumer consumer = new GitUpdateCommandConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cl = GitUpdateCommand.createStash(repository, fileSet.getBasedir());
        int exitCode = GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode != 0) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("failed to stash, return code " + exitCode);
            }
            return new UpdateScmResult(cl.toString(), "The git-pull command failed.", stderr.getOutput(), false);
        }
        cl = GitUpdateCommand.createCommandLine(repository, fileSet.getBasedir(), scmVersion);
        exitCode = GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode != 0) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("failed to update git, return code " + exitCode);
            }
            return new UpdateScmResult(cl.toString(), "The git-pull command failed.", stderr.getOutput(), false);
        }
        cl = GitUpdateCommand.createStashPop(repository, fileSet.getBasedir());
        exitCode = GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode > 1) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("failed to unstash, return code " + exitCode);
            }
            return new UpdateScmResult(cl.toString(), "The git-pull command failed.", stderr.getOutput(), false);
        }
        Commandline clRev = GitUpdateCommand.createLatestRevisionCommandLine(repository, fileSet.getBasedir(), scmVersion);
        exitCode = GitCommandLineUtils.execute((Commandline)clRev, (StreamConsumer)(consumerRev = new GitLatestRevisionCommandConsumer(this.getLogger())), (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
        if (exitCode != 0) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("failed to update git, return code " + exitCode);
            }
            return new UpdateScmResult(cl.toString(), "The git-log command failed.", stderr.getOutput(), false);
        }
        String latestRevision = consumerRev.getLatestRevision();
        return new UpdateScmResultWithRevision(cl.toString(), consumer.getUpdatedFiles(), latestRevision);
    }

    protected ChangeLogCommand getChangeLogCommand() {
        GitChangeLogCommand changelogCmd = new GitChangeLogCommand();
        changelogCmd.setLogger(this.getLogger());
        return changelogCmd;
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmVersion scmVersion) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)workingDirectory, (String)"pull");
        cl.createArg().setLine("--rebase");
        cl.createArg().setLine(repository.getFetchUrl());
        if (scmVersion instanceof ScmBranch) {
            cl.createArg().setLine(scmVersion.getName());
        } else {
            cl.createArg().setLine("master");
        }
        return cl;
    }

    public static Commandline createLatestRevisionCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmVersion scmVersion) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)workingDirectory, (String)"log");
        cl.createArg().setValue("-n1");
        cl.createArg().setValue("--date-order");
        if (scmVersion != null && scmVersion instanceof ScmBranch && scmVersion.getName() != null && scmVersion.getName().length() > 0) {
            cl.createArg().setValue(scmVersion.getName());
        } else {
            cl.createArg().setValue("master");
        }
        return cl;
    }

    public static Commandline createStash(GitScmProviderRepository repository, File workingDirectory) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)workingDirectory, (String)"stash");
        cl.createArg().setValue("save");
        return cl;
    }

    public static Commandline createStashPop(GitScmProviderRepository repository, File workingDirectory) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)workingDirectory, (String)"stash");
        cl.createArg().setValue("pop");
        return cl;
    }
}

