/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.toolchain.jdk;

import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.toolchain.jdk.ToolchainDiscoverer;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="display-discovered-jdk-toolchains", requiresProject=false)
public class DisplayDiscoveredJdkToolchainsMojo
extends AbstractMojo {
    @Parameter(property="toolchain.jdk.comparator", defaultValue="lts,current,env,version,vendor")
    String comparator;
    @Inject
    ToolchainDiscoverer discoverer;

    public void execute() {
        PersistedToolchains toolchains = this.discoverer.discoverToolchains(this.comparator);
        List models = toolchains.getToolchains();
        this.getLog().info((CharSequence)("Discovered " + models.size() + " JDK toolchains:"));
        for (ToolchainModel model : models) {
            this.getLog().info((CharSequence)("  - " + ((Xpp3Dom)model.getConfiguration()).getChild("jdkHome").getValue()));
            this.getLog().info((CharSequence)"    provides:");
            model.getProvides().entrySet().stream().sorted(Comparator.comparing(e -> ToolchainDiscoverer.SORTED_PROVIDES.indexOf(e.getKey().toString()))).forEach(e -> this.getLog().info((CharSequence)("      " + e.getKey() + ": " + e.getValue())));
        }
    }
}

