/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.bazaar.BazaarUtils;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;
import org.codehaus.plexus.util.cli.Commandline;

public class BazaarConfig {
    private static final float BAZAAR_REQ = 0.7f;
    private static final float PYTHON_REQ = 2.4f;
    private static final String BAZAAR_VERSION_TAG = "bzr (bazaar-ng) ";
    private static final String BAZAAR_INSTALL_URL = "'http://bazaar-vcs.org/Installation'";
    private static final String PYTHON_EXEC = "python";
    private static final String PYTHON_VERSION = "-V";
    private static final String PYTHON_VERSION_TAG = "Python ";
    private static final String PARAMIKO = "\"import paramiko\"";
    private static final String CCRYPT = "\"import Crypto\"";
    private static final String CELEMENTREE = "\"import cElementTree\"";
    private VersionConsumer bazaarVersion = new VersionConsumer(null);
    private VersionConsumer pythonVersion = new VersionConsumer(null);
    private boolean cElementTree = false;
    private boolean paramiko = false;
    private boolean cCrypt = false;

    BazaarConfig(File workingDir) {
        try {
            this.pythonVersion = BazaarConfig.getPythonVersion(workingDir);
            this.paramiko = this.checkPyModules(workingDir, PARAMIKO);
            this.cCrypt = this.checkPyModules(workingDir, CCRYPT);
            this.cElementTree = this.checkPyModules(workingDir, CELEMENTREE);
            this.bazaarVersion = BazaarConfig.getBazaarVersion(workingDir);
        }
        catch (ScmException scmException) {
            // empty catch block
        }
    }

    private boolean checkPyModules(File workingDir, String cmd) {
        int exitCode;
        PythonConsumer consumer = new PythonConsumer();
        try {
            Commandline cmdLine = BazaarConfig.buildPythonCmd(workingDir, new String[]{"-c", cmd});
            exitCode = BazaarUtils.executeCmd(consumer, cmdLine);
        }
        catch (ScmException e) {
            exitCode = -1;
        }
        return exitCode == 0 && consumer.getConsumedAndClear().equals("");
    }

    private boolean isInstalled() {
        return this.pythonVersion.isVersionOk(2.4f) && this.bazaarVersion.isVersionOk(0.7f);
    }

    private boolean isComplete() {
        return this.isInstalled() && this.cElementTree && this.paramiko && this.cCrypt;
    }

    public static VersionConsumer getBazaarVersion(File workingDir) throws ScmException {
        String[] versionCmd = new String[]{"version"};
        VersionConsumer consumer = new VersionConsumer(BAZAAR_VERSION_TAG);
        Commandline cmd = BazaarUtils.buildCmd(workingDir, versionCmd);
        BazaarUtils.executeCmd(consumer, cmd);
        return consumer;
    }

    public static VersionConsumer getPythonVersion(File workingDir) throws ScmException {
        String[] versionCmd = new String[]{PYTHON_VERSION};
        VersionConsumer consumer = new VersionConsumer(PYTHON_VERSION_TAG);
        Commandline cmd = BazaarConfig.buildPythonCmd(workingDir, versionCmd);
        BazaarUtils.executeCmd(consumer, cmd);
        return consumer;
    }

    private static Commandline buildPythonCmd(File workingDir, String[] cmdAndArgs) throws ScmException {
        boolean success;
        Commandline cmd = new Commandline();
        cmd.setExecutable(PYTHON_EXEC);
        cmd.setWorkingDirectory(workingDir.getAbsolutePath());
        cmd.addArguments(cmdAndArgs);
        if (!workingDir.exists() && !(success = workingDir.mkdirs())) {
            String msg = "Working directory did not exist and it couldn't be created: " + workingDir;
            throw new ScmException(msg);
        }
        return cmd;
    }

    private String getInstalledStr() {
        if (this.isComplete()) {
            return "valid and complete.";
        }
        return (this.isInstalled() ? "incomplete. " : "invalid. ") + "Consult " + BAZAAR_INSTALL_URL;
    }

    public String toString(File workingDir) {
        boolean bzrOk = this.bazaarVersion.isVersionOk(0.7f);
        boolean pyOk = this.pythonVersion.isVersionOk(2.4f);
        return "\n  Your Bazaar installation seems to be " + this.getInstalledStr() + "\n    Python version: " + this.pythonVersion.getVersion() + (pyOk ? " (OK)" : " (May be INVALID)") + "\n    Bazaar version: " + this.bazaarVersion.getVersion() + (bzrOk ? " (OK)" : " (May be INVALID)") + "\n    Paramiko installed: " + this.paramiko + " (For remote access eg. sftp) \n    cCrypt installed: " + this.cCrypt + " (For remote access eg. sftp) \n    cElementTree installed: " + this.cElementTree + " (Not mandatory) \n";
    }

    private static class PythonConsumer
    extends BazaarConsumer {
        private String consumed = "";

        PythonConsumer() {
            super((ScmLogger)new DefaultLog());
        }

        @Override
        public void doConsume(ScmFileStatus status, String line) {
            this.consumed = line;
        }

        String getConsumedAndClear() {
            String tmp = this.consumed;
            this.consumed = "";
            return tmp;
        }
    }

    private static class VersionConsumer
    extends BazaarConsumer {
        private static final Pattern VERSION_PATTERN = Pattern.compile("[\\d]+.?[\\d]*");
        private final String versionTag;
        private String versionStr = "NA";
        private float version = -1.0f;

        VersionConsumer(String aVersionTag) {
            super((ScmLogger)new DefaultLog());
            this.versionTag = aVersionTag;
        }

        @Override
        public void doConsume(ScmFileStatus status, String line) {
            if (line.startsWith(this.versionTag)) {
                this.versionStr = line.substring(this.versionTag.length());
            }
        }

        String getVersion() {
            return this.versionStr;
        }

        boolean isVersionOk(float min) {
            block3: {
                Matcher matcher = VERSION_PATTERN.matcher(this.versionStr);
                if (matcher.find()) {
                    String subStr = this.versionStr.substring(matcher.start(), matcher.end());
                    try {
                        this.version = Float.valueOf(subStr).floatValue();
                    }
                    catch (NumberFormatException e) {
                        if (!this.getLogger().isErrorEnabled()) break block3;
                        this.getLogger().error("Regexp for version did not result in a number: " + subStr, (Throwable)e);
                    }
                }
            }
            return min <= this.version;
        }
    }
}

