/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.changelog;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.changelog.ClearCaseChangeLogConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseChangeLogCommand
extends AbstractChangeLogCommand
implements ClearCaseCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        int exitCode;
        this.getLogger().debug("executing changelog command...");
        Commandline cl = ClearCaseChangeLogCommand.createCommandLine(fileSet.getBasedir(), branch, startDate);
        ClearCaseChangeLogConsumer consumer = new ClearCaseChangeLogConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing cvs command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new ChangeLogScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new ChangeLogScmResult(cl.toString(), consumer.getModifications());
    }

    public static Commandline createCommandLine(File workingDirectory, String branch, Date startDate) {
        Commandline command = new Commandline();
        command.setExecutable("cleartool");
        command.createArgument().setValue("lshistory");
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        StringBuffer format = new StringBuffer();
        format.append("NAME:%En\\n");
        format.append("DATE:%Nd\\n");
        format.append("COMM:%-12.12o - %o - %c - Activity: %[activity]p\\n");
        format.append("USER:%-8.8u\\n");
        command.createArgument().setValue("-fmt");
        command.createArgument().setValue(format.toString());
        command.createArgument().setValue("-recurse");
        command.createArgument().setValue("-nco");
        if (startDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
            String start = sdf.format(startDate);
            command.createArgument().setValue("-since");
            command.createArgument().setValue(start);
        }
        if (branch != null) {
            command.createArgument().setValue("-branch");
            command.createArgument().setValue(branch);
        }
        return command;
    }
}

