/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.checkin;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.checkin.ClearCaseCheckInConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseCheckInCommand
extends AbstractCheckInCommand
implements ClearCaseCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String message, String tag) throws ScmException {
        int exitCode;
        this.getLogger().debug("executing checkin command...");
        Commandline cl = ClearCaseCheckInCommand.createCommandLine(fileSet, message);
        ClearCaseCheckInConsumer consumer = new ClearCaseCheckInConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new CheckInScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new CheckInScmResult(cl.toString(), consumer.getCheckedInFiles());
    }

    public static Commandline createCommandLine(ScmFileSet scmFileSet, String message) throws ScmException {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("ci");
        if (message != null) {
            command.createArgument().setValue("-c");
            command.createArgument().setLine("\"" + message + "\"");
        } else {
            command.createArgument().setValue("-nc");
        }
        File[] files = scmFileSet.getFiles();
        if (files.length == 0) {
            throw new ScmException("There are no files in the fileset to check in!");
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            command.createArgument().setValue(file.getAbsolutePath());
        }
        return command;
    }
}

