/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.repository;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class ClearCaseScmProviderRepository
extends ScmProviderRepository {
    private boolean viewNameGivenByUser = false;
    private String viewName;
    private File configSpec;

    public ClearCaseScmProviderRepository(String url) throws ScmRepositoryException {
        try {
            this.parseUrl(url);
        }
        catch (MalformedURLException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
        catch (URISyntaxException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
        catch (UnknownHostException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
    }

    private void parseUrl(String url) throws MalformedURLException, URISyntaxException, UnknownHostException {
        if (url.indexOf(124) != -1) {
            StringTokenizer tokenizer = new StringTokenizer(url, "|");
            this.fillInProperties(tokenizer);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(url, ":");
            this.fillInProperties(tokenizer);
        }
    }

    private void fillInProperties(StringTokenizer tokenizer) throws UnknownHostException, URISyntaxException, MalformedURLException {
        if (tokenizer.countTokens() == 1) {
            this.viewName = this.getDefaultViewName();
            String spec = tokenizer.nextToken();
            System.out.println("spec = " + spec);
            this.configSpec = this.createConfigSpecFile(spec);
        } else {
            this.viewName = tokenizer.nextToken();
            this.viewNameGivenByUser = true;
            System.out.println("viewName = " + this.viewName);
            String pathname = tokenizer.nextToken();
            System.out.println("pathname = " + pathname);
            this.configSpec = this.createConfigSpecFile(pathname);
        }
    }

    private File createConfigSpecFile(String spec) throws URISyntaxException, MalformedURLException {
        File result = spec.indexOf(58) == -1 ? new File(spec) : new File(new URL(spec).toURI());
        return result;
    }

    private String getDefaultViewName() throws UnknownHostException {
        String username = System.getProperty("user.name", "nouser");
        String hostname = this.getHostName();
        return username + "-" + hostname + "-maven";
    }

    private String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public String getViewName(String uniqueId) {
        String result = this.viewNameGivenByUser ? this.viewName : this.viewName + "-" + uniqueId;
        return result;
    }

    public File getConfigSpec() {
        return this.configSpec;
    }
}

