/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.ControllerServiceConfiguration;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockPropertyValue;
import org.apache.nifi.util.MockValidationContext;
import org.junit.Assert;

public class MockProcessContext
extends MockControllerServiceLookup
implements ProcessContext,
ControllerServiceLookup,
NodeTypeProvider {
    private final ConfigurableComponent component;
    private final String componentName;
    private final Map<PropertyDescriptor, String> properties = new HashMap<PropertyDescriptor, String>();
    private final StateManager stateManager;
    private final VariableRegistry variableRegistry;
    private String annotationData = null;
    private boolean yieldCalled = false;
    private boolean enableExpressionValidation = false;
    private boolean allowExpressionValidation = true;
    private volatile boolean incomingConnection = true;
    private volatile boolean nonLoopConnection = true;
    private volatile InputRequirement inputRequirement = null;
    private int maxConcurrentTasks = 1;
    private volatile Set<Relationship> connections = new HashSet<Relationship>();
    private volatile Set<Relationship> unavailableRelationships = new HashSet<Relationship>();
    private volatile boolean isClustered;
    private volatile boolean isPrimaryNode;

    public MockProcessContext(ConfigurableComponent component) {
        this(component, null);
    }

    public MockProcessContext(ConfigurableComponent component, String componentName) {
        this(component, componentName, (StateManager)new MockStateManager(component), VariableRegistry.EMPTY_REGISTRY);
    }

    public MockProcessContext(ConfigurableComponent component, StateManager stateManager, VariableRegistry variableRegistry) {
        this(component, null, stateManager, variableRegistry);
    }

    public MockProcessContext(ConfigurableComponent component, String componentName, StateManager stateManager, VariableRegistry variableRegistry) {
        this.component = Objects.requireNonNull(component);
        this.componentName = componentName == null ? "" : componentName;
        this.inputRequirement = component.getClass().getAnnotation(InputRequirement.class);
        this.stateManager = stateManager;
        this.variableRegistry = variableRegistry;
    }

    public MockProcessContext(ControllerService component, MockProcessContext context, StateManager stateManager, VariableRegistry variableRegistry) {
        this(component, null, context, stateManager, variableRegistry);
    }

    public MockProcessContext(ControllerService component, String componentName, MockProcessContext context, StateManager stateManager, VariableRegistry variableRegistry) {
        this((ConfigurableComponent)component, componentName, stateManager, variableRegistry);
        try {
            this.annotationData = context.getControllerServiceAnnotationData(component);
            Map<PropertyDescriptor, String> props = context.getControllerServiceProperties(component);
            this.properties.putAll(props);
            super.addControllerServices(context);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.getProperty(descriptor.getName());
    }

    public PropertyValue getProperty(String propertyName) {
        PropertyDescriptor descriptor = this.component.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return null;
        }
        String setPropertyValue = this.properties.get(descriptor);
        String propValue = setPropertyValue == null ? descriptor.getDefaultValue() : setPropertyValue;
        return new MockPropertyValue(propValue, this, this.variableRegistry, this.enableExpressionValidation && this.allowExpressionValidation ? descriptor : null);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new MockPropertyValue(rawValue, this, this.variableRegistry);
    }

    public ValidationResult setProperty(String propertyName, String propertyValue) {
        return this.setProperty(new PropertyDescriptor.Builder().name(propertyName).build(), propertyValue);
    }

    public ValidationResult setProperty(PropertyDescriptor descriptor, String value) {
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(value, "Cannot set property to null value; if the intent is to remove the property, call removeProperty instead");
        PropertyDescriptor fullyPopulatedDescriptor = this.component.getPropertyDescriptor(descriptor.getName());
        ValidationResult result = fullyPopulatedDescriptor.validate(value, (ValidationContext)new MockValidationContext(this, this.stateManager, this.variableRegistry));
        String oldValue = this.properties.put(fullyPopulatedDescriptor, value);
        if (oldValue == null) {
            oldValue = fullyPopulatedDescriptor.getDefaultValue();
        }
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.component.onPropertyModified(fullyPopulatedDescriptor, oldValue, value);
        }
        return result;
    }

    public boolean removeProperty(PropertyDescriptor descriptor) {
        Objects.requireNonNull(descriptor);
        return this.removeProperty(descriptor.getName());
    }

    public boolean removeProperty(String property) {
        Objects.requireNonNull(property);
        PropertyDescriptor fullyPopulatedDescriptor = this.component.getPropertyDescriptor(property);
        String value = null;
        value = this.properties.remove(fullyPopulatedDescriptor);
        if (value != null) {
            if (!value.equals(fullyPopulatedDescriptor.getDefaultValue())) {
                this.component.onPropertyModified(fullyPopulatedDescriptor, value, null);
            }
            return true;
        }
        return false;
    }

    public void clearProperties() {
        Map<PropertyDescriptor, String> properties = this.getProperties();
        for (Map.Entry<PropertyDescriptor, String> e : properties.entrySet()) {
            this.removeProperty(e.getKey());
        }
    }

    public void yield() {
        this.yieldCalled = true;
    }

    public boolean isYieldCalled() {
        return this.yieldCalled;
    }

    public void addControllerService(String serviceIdentifier, ControllerService controllerService, Map<PropertyDescriptor, String> properties, String annotationData) {
        Objects.requireNonNull(controllerService);
        ControllerServiceConfiguration config = this.addControllerService(controllerService);
        config.setProperties(properties);
        config.setAnnotationData(annotationData);
    }

    public int getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public ExecutionNode getExecutionNode() {
        return ExecutionNode.ALL;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public Map<PropertyDescriptor, String> getProperties() {
        List supported = this.component.getPropertyDescriptors();
        if (supported == null || supported.isEmpty()) {
            return Collections.unmodifiableMap(this.properties);
        }
        LinkedHashMap<PropertyDescriptor, String> props = new LinkedHashMap<PropertyDescriptor, String>();
        for (PropertyDescriptor descriptor : supported) {
            props.put(descriptor, null);
        }
        props.putAll(this.properties);
        return props;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public Collection<ValidationResult> validate() {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        MockValidationContext validationContext = new MockValidationContext(this, this.stateManager, this.variableRegistry);
        Collection componentResults = this.component.validate((ValidationContext)validationContext);
        results.addAll(componentResults);
        Collection<ValidationResult> serviceResults = this.validateReferencedControllerServices(validationContext);
        results.addAll(serviceResults);
        for (Map.Entry<String, ControllerServiceConfiguration> service : this.getControllerServices().entrySet()) {
            if (service.getValue().isEnabled()) continue;
            results.add(new ValidationResult.Builder().explanation("Controller service " + service.getKey() + " for " + this.getName() + " is not enabled").valid(false).build());
        }
        return results;
    }

    protected final Collection<ValidationResult> validateReferencedControllerServices(ValidationContext validationContext) {
        List supportedDescriptors = this.component.getPropertyDescriptors();
        if (supportedDescriptors == null) {
            return Collections.emptyList();
        }
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (PropertyDescriptor descriptor : supportedDescriptors) {
            String controllerServiceId;
            if (descriptor.getControllerServiceDefinition() == null || (controllerServiceId = validationContext.getProperty(descriptor).getValue()) == null) continue;
            ControllerService controllerService = this.getControllerService(controllerServiceId);
            if (controllerService == null) {
                ValidationResult result = new ValidationResult.Builder().valid(false).subject(descriptor.getDisplayName()).input(controllerServiceId).explanation("Invalid Controller Service: " + controllerServiceId + " is not a valid Controller Service Identifier").build();
                validationResults.add(result);
                continue;
            }
            Class requiredServiceClass = descriptor.getControllerServiceDefinition();
            if (!requiredServiceClass.isAssignableFrom(controllerService.getClass())) {
                ValidationResult result = new ValidationResult.Builder().valid(false).subject(descriptor.getDisplayName()).input(controllerServiceId).explanation("Invalid Controller Service: " + controllerServiceId + " does not implement interface " + requiredServiceClass).build();
                validationResults.add(result);
                continue;
            }
            boolean enabled = this.isControllerServiceEnabled(controllerServiceId);
            if (enabled) continue;
            validationResults.add(new ValidationResult.Builder().input(controllerServiceId).subject(descriptor.getDisplayName()).explanation("Controller Service with ID " + controllerServiceId + " is not enabled").valid(false).build());
        }
        return validationResults;
    }

    public boolean isValid() {
        for (ValidationResult result : this.validate()) {
            if (result.isValid()) continue;
            return false;
        }
        return true;
    }

    public void assertValid() {
        StringBuilder sb = new StringBuilder();
        int failureCount = 0;
        for (ValidationResult result : this.validate()) {
            if (result.isValid()) continue;
            sb.append(result.toString()).append("\n");
            ++failureCount;
        }
        if (failureCount > 0) {
            Assert.fail((String)("Processor has " + failureCount + " validation failures:\n" + sb.toString()));
        }
    }

    public String encrypt(String unencrypted) {
        return "enc{" + unencrypted + "}";
    }

    public String decrypt(String encrypted) {
        if (encrypted.startsWith("enc{") && encrypted.endsWith("}")) {
            return encrypted.substring(4, encrypted.length() - 1);
        }
        return encrypted;
    }

    public void setValidateExpressionUsage(boolean validate) {
        this.allowExpressionValidation = validate;
    }

    public void enableExpressionValidation() {
        this.enableExpressionValidation = true;
    }

    public void disableExpressionValidation() {
        this.enableExpressionValidation = false;
    }

    Map<PropertyDescriptor, String> getControllerServiceProperties(ControllerService controllerService) {
        return super.getConfiguration(controllerService.getIdentifier()).getProperties();
    }

    String getControllerServiceAnnotationData(ControllerService controllerService) {
        return super.getConfiguration(controllerService.getIdentifier()).getAnnotationData();
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public Set<Relationship> getAvailableRelationships() {
        if (!(this.component instanceof Processor)) {
            return Collections.emptySet();
        }
        HashSet<Relationship> relationships = new HashSet<Relationship>(((Processor)this.component).getRelationships());
        relationships.removeAll(this.unavailableRelationships);
        return relationships;
    }

    public void setUnavailableRelationships(Set<Relationship> relationships) {
        this.unavailableRelationships = Collections.unmodifiableSet(new HashSet<Relationship>(relationships));
    }

    public Set<Relationship> getUnavailableRelationships() {
        return this.unavailableRelationships;
    }

    public boolean hasIncomingConnection() {
        return this.incomingConnection;
    }

    public void setIncomingConnection(boolean hasIncomingConnection) {
        this.incomingConnection = hasIncomingConnection;
    }

    public boolean hasConnection(Relationship relationship) {
        return this.connections.contains(relationship);
    }

    public void setNonLoopConnection(boolean hasNonLoopConnection) {
        this.nonLoopConnection = hasNonLoopConnection;
    }

    public boolean hasNonLoopConnection() {
        return this.nonLoopConnection;
    }

    public void addConnection(Relationship relationship) {
        this.connections.add(relationship);
    }

    public void removeConnection(Relationship relationship) {
        this.connections.remove(relationship);
    }

    public void setConnections(Set<Relationship> connections) {
        this.connections = connections == null ? Collections.emptySet() : Collections.unmodifiableSet(connections);
    }

    public boolean isExpressionLanguagePresent(PropertyDescriptor property) {
        if (property == null || !property.isExpressionLanguageSupported()) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.getProperty(property).getValue());
        return elRanges != null && !elRanges.isEmpty();
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getName() {
        return this.componentName;
    }

    protected void setMaxConcurrentTasks(int maxConcurrentTasks) {
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public boolean isPrimary() {
        return this.isPrimaryNode;
    }

    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    public void setPrimaryNode(boolean primaryNode) {
        if (!this.isClustered && primaryNode) {
            throw new IllegalArgumentException("Primary node is only available in cluster. Use setClustered(true) first.");
        }
        this.isPrimaryNode = primaryNode;
    }

    @Override
    public InputRequirement getInputRequirement() {
        return this.inputRequirement;
    }
}

