/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.MockControllerServiceLookup;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.MockValidationContext;

public class MockPropertyValue
implements PropertyValue {
    private final String rawValue;
    private final Boolean expectExpressions;
    private final ExpressionLanguageScope expressionLanguageScope;
    private final MockControllerServiceLookup serviceLookup;
    private final PropertyDescriptor propertyDescriptor;
    private final PropertyValue stdPropValue;
    private final VariableRegistry variableRegistry;
    private boolean expressionsEvaluated = false;

    public MockPropertyValue(String rawValue) {
        this(rawValue, null);
    }

    public MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup) {
        this(rawValue, serviceLookup, VariableRegistry.EMPTY_REGISTRY, null);
    }

    public MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, VariableRegistry variableRegistry) {
        this(rawValue, serviceLookup, variableRegistry, null);
    }

    public MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, VariableRegistry variableRegistry, PropertyDescriptor propertyDescriptor) {
        this(rawValue, serviceLookup, propertyDescriptor, false, variableRegistry);
    }

    private MockPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, PropertyDescriptor propertyDescriptor, boolean alreadyEvaluated, VariableRegistry variableRegistry) {
        this.stdPropValue = new StandardPropertyValue(rawValue, serviceLookup, ParameterLookup.EMPTY, variableRegistry);
        this.rawValue = rawValue;
        this.serviceLookup = (MockControllerServiceLookup)serviceLookup;
        this.expectExpressions = propertyDescriptor == null ? null : Boolean.valueOf(propertyDescriptor.isExpressionLanguageSupported());
        this.expressionLanguageScope = propertyDescriptor == null ? null : propertyDescriptor.getExpressionLanguageScope();
        this.propertyDescriptor = propertyDescriptor;
        this.expressionsEvaluated = alreadyEvaluated;
        this.variableRegistry = variableRegistry;
    }

    private void ensureExpressionsEvaluated() {
        if (Boolean.TRUE.equals(this.expectExpressions) && !this.expressionsEvaluated) {
            throw new IllegalStateException("Attempting to retrieve value of " + this.propertyDescriptor + " without first evaluating Expressions, even though the PropertyDescriptor indicates that the Expression Language is Supported. If you realize that this is the case and do not want this error to occur, it can be disabled by calling TestRunner.setValidateExpressionUsage(false)");
        }
    }

    private void validateExpressionScope(boolean attributesAvailable) {
        if (this.expressionLanguageScope != null && attributesAvailable && !ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope)) {
            throw new IllegalStateException("Attempting to evaluate expression language for " + this.propertyDescriptor.getName() + " using flow file attributes but the scope evaluation is set to " + this.expressionLanguageScope + ". The proper scope should be set in the property descriptor using PropertyDescriptor.Builder.expressionLanguageSupported(ExpressionLanguageScope)");
        }
        if (this.expressionLanguageScope != null && ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope) && this.serviceLookup instanceof MockValidationContext) {
            return;
        }
        if (this.expressionLanguageScope != null && ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope) && (this.serviceLookup.getInputRequirement() == null || this.serviceLookup.getInputRequirement().value().equals((Object)InputRequirement.Requirement.INPUT_FORBIDDEN))) {
            return;
        }
        if (this.expressionLanguageScope != null && ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope) && !((MockProcessContext)this.serviceLookup).hasIncomingConnection()) {
            return;
        }
        if (this.expressionLanguageScope != null && !attributesAvailable && ExpressionLanguageScope.FLOWFILE_ATTRIBUTES.equals((Object)this.expressionLanguageScope)) {
            throw new IllegalStateException("Attempting to evaluate expression language for " + this.propertyDescriptor.getName() + " without using flow file attributes but the scope evaluation is set to " + this.expressionLanguageScope + ". The proper scope should be set in the property descriptor using PropertyDescriptor.Builder.expressionLanguageSupported(ExpressionLanguageScope)");
        }
    }

    public String getValue() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.getValue();
    }

    public Integer asInteger() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asInteger();
    }

    public Long asLong() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asLong();
    }

    public Boolean asBoolean() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asBoolean();
    }

    public Float asFloat() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asFloat();
    }

    public Double asDouble() {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asDouble();
    }

    public Long asTimePeriod(TimeUnit timeUnit) {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asTimePeriod(timeUnit);
    }

    public Double asDataSize(DataUnit dataUnit) {
        this.ensureExpressionsEvaluated();
        return this.stdPropValue.asDataSize(dataUnit);
    }

    private void markEvaluated() {
        if (Boolean.FALSE.equals(this.expectExpressions)) {
            throw new IllegalStateException("Attempting to Evaluate Expressions but " + this.propertyDescriptor + " indicates that the Expression Language is not supported. If you realize that this is the case and do not want this error to occur, it can be disabled by calling TestRunner.setValidateExpressionUsage(false)");
        }
        this.expressionsEvaluated = true;
    }

    public PropertyValue evaluateAttributeExpressions() throws ProcessException {
        return this.evaluateAttributeExpressions(null, null, null);
    }

    public PropertyValue evaluateAttributeExpressions(AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(null, null, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile) throws ProcessException {
        if (flowFile == null && this.expressionLanguageScope == ExpressionLanguageScope.FLOWFILE_ATTRIBUTES) {
            return this.evaluateAttributeExpressions(new HashMap<String, String>());
        }
        if (flowFile == null && this.expressionLanguageScope == ExpressionLanguageScope.VARIABLE_REGISTRY) {
            return this.evaluateAttributeExpressions();
        }
        return this.evaluateAttributeExpressions(flowFile, null, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, null, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, additionalAttributes, null);
    }

    public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes) throws ProcessException {
        return this.evaluateAttributeExpressions(null, attributes, null);
    }

    public PropertyValue evaluateAttributeExpressions(Map<String, String> attributes, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(null, attributes, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, additionalAttributes, decorator, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, Map<String, String> additionalAttributes, AttributeValueDecorator decorator, Map<String, String> stateValues) throws ProcessException {
        this.markEvaluated();
        if (this.rawValue == null) {
            return this;
        }
        this.validateExpressionScope(flowFile != null || additionalAttributes != null);
        PropertyValue newValue = this.stdPropValue.evaluateAttributeExpressions(flowFile, additionalAttributes, decorator, stateValues);
        return new MockPropertyValue(newValue.getValue(), this.serviceLookup, this.propertyDescriptor, true, this.variableRegistry);
    }

    public ControllerService asControllerService() {
        this.ensureExpressionsEvaluated();
        if (this.rawValue == null || this.rawValue.equals("")) {
            return null;
        }
        return this.serviceLookup.getControllerService(this.rawValue);
    }

    public <T extends ControllerService> T asControllerService(Class<T> serviceType) throws IllegalArgumentException {
        this.ensureExpressionsEvaluated();
        if (this.rawValue == null || this.rawValue.equals("")) {
            return null;
        }
        ControllerService service = this.serviceLookup.getControllerService(this.rawValue);
        if (serviceType.isAssignableFrom(service.getClass())) {
            return (T)((ControllerService)serviceType.cast(service));
        }
        throw new IllegalArgumentException("Controller Service with identifier " + this.rawValue + " is of type " + service.getClass() + " and cannot be cast to " + serviceType);
    }

    public boolean isSet() {
        return this.rawValue != null;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean isExpressionLanguagePresent() {
        if (this.rawValue == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.rawValue);
        return elRanges != null && !elRanges.isEmpty();
    }
}

