/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import org.apache.nifi.processor.Processor;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.StandardProcessorTestRunner;
import org.apache.nifi.util.TestRunner;

public class TestRunners {
    public static TestRunner newTestRunner(Processor processor) {
        return TestRunners.newTestRunner(processor, processor.getClass().getName());
    }

    public static TestRunner newTestRunner(Processor processor, MockComponentLog logger) {
        return TestRunners.newTestRunner(processor, processor.getClass().getName(), logger);
    }

    public static TestRunner newTestRunner(Processor processor, String name) {
        return new StandardProcessorTestRunner(processor, name);
    }

    public static TestRunner newTestRunner(Processor processor, String name, MockComponentLog logger) {
        return new StandardProcessorTestRunner(processor, name, logger);
    }

    public static TestRunner newTestRunner(Class<? extends Processor> processorClass) {
        return TestRunners.newTestRunner(processorClass, processorClass.getName());
    }

    public static TestRunner newTestRunner(Class<? extends Processor> processorClass, MockComponentLog logger) {
        return TestRunners.newTestRunner(processorClass, processorClass.getName(), logger);
    }

    public static TestRunner newTestRunner(Class<? extends Processor> processorClass, String name) {
        try {
            return TestRunners.newTestRunner(processorClass.newInstance(), name);
        }
        catch (Exception e) {
            System.err.println("Could not instantiate instance of class " + processorClass.getName() + " due to: " + e);
            throw new RuntimeException(e);
        }
    }

    public static TestRunner newTestRunner(Class<? extends Processor> processorClass, String name, MockComponentLog logger) {
        try {
            return TestRunners.newTestRunner(processorClass.newInstance(), name, logger);
        }
        catch (Exception e) {
            System.err.println("Could not instantiate instance of class " + processorClass.getName() + " due to: " + e);
            throw new RuntimeException(e);
        }
    }
}

