/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.wali;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.wali.RecordLookup;
import org.apache.nifi.wali.SnapshotCapture;
import org.apache.nifi.wali.SnapshotRecovery;
import org.apache.nifi.wali.StandardSnapshotRecovery;
import org.apache.nifi.wali.WriteAheadSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.SerDe;
import org.wali.SerDeFactory;
import org.wali.UpdateType;

public class HashMapSnapshot<T>
implements WriteAheadSnapshot<T>,
RecordLookup<T> {
    private static final Logger logger = LoggerFactory.getLogger(HashMapSnapshot.class);
    private static final int ENCODING_VERSION = 1;
    private final ConcurrentMap<Object, T> recordMap = new ConcurrentHashMap<Object, T>();
    private final SerDeFactory<T> serdeFactory;
    private final Set<String> swapLocations = Collections.synchronizedSet(new HashSet());
    private final File storageDirectory;

    public HashMapSnapshot(File storageDirectory, SerDeFactory<T> serdeFactory) {
        this.serdeFactory = serdeFactory;
        this.storageDirectory = storageDirectory;
    }

    private SnapshotHeader validateHeader(DataInputStream dataIn) throws IOException {
        String snapshotClass = dataIn.readUTF();
        logger.debug("Snapshot Class Name for {} is {}", (Object)this.storageDirectory, (Object)snapshotClass);
        if (!snapshotClass.equals(HashMapSnapshot.class.getName())) {
            throw new IOException("Write-Ahead Log Snapshot located at " + this.storageDirectory + " was written using the " + snapshotClass + " class; cannot restore using " + this.getClass().getName());
        }
        int snapshotVersion = dataIn.readInt();
        logger.debug("Snapshot version for {} is {}", (Object)this.storageDirectory, (Object)snapshotVersion);
        if (snapshotVersion > this.getVersion()) {
            throw new IOException("Write-Ahead Log Snapshot located at " + this.storageDirectory + " was written using version " + snapshotVersion + " of the " + snapshotClass + " class; cannot restore using Version " + this.getVersion());
        }
        String serdeEncoding = dataIn.readUTF();
        logger.debug("Serde encoding for Snapshot at {} is {}", (Object)this.storageDirectory, (Object)serdeEncoding);
        int serdeVersion = dataIn.readInt();
        logger.debug("Serde version for Snapshot at {} is {}", (Object)this.storageDirectory, (Object)serdeVersion);
        long maxTransactionId = dataIn.readLong();
        logger.debug("Max Transaction ID for Snapshot at {} is {}", (Object)this.storageDirectory, (Object)maxTransactionId);
        int numRecords = dataIn.readInt();
        logger.debug("Number of Records for Snapshot at {} is {}", (Object)this.storageDirectory, (Object)numRecords);
        SerDe<T> serde = this.serdeFactory.createSerDe(serdeEncoding);
        serde.readHeader(dataIn);
        return new SnapshotHeader(serde, serdeVersion, maxTransactionId, numRecords);
    }

    @Override
    public SnapshotRecovery<T> recover() throws IOException {
        File partialFile = this.getPartialFile();
        File snapshotFile = this.getSnapshotFile();
        boolean partialExists = partialFile.exists();
        boolean snapshotExists = snapshotFile.exists();
        if (!partialExists && !snapshotExists) {
            return SnapshotRecovery.emptyRecovery();
        }
        if (partialExists && snapshotExists) {
            Files.delete(partialFile.toPath());
        } else if (partialExists) {
            Files.move(partialFile.toPath(), snapshotFile.toPath(), new CopyOption[0]);
        }
        if (snapshotFile.length() == 0L) {
            logger.warn("{} Found 0-byte Snapshot file; skipping Snapshot file in recovery", (Object)this);
            return SnapshotRecovery.emptyRecovery();
        }
        try (DataInputStream dataIn = new DataInputStream(new BufferedInputStream(new FileInputStream(snapshotFile)));){
            SnapshotHeader header = this.validateHeader(dataIn);
            SerDe serde = header.getSerDe();
            int serdeVersion = header.getSerDeVersion();
            int numRecords = header.getNumRecords();
            long maxTransactionId = header.getMaxTransactionId();
            for (int i = 0; i < numRecords; ++i) {
                Object record = serde.deserializeRecord(dataIn, serdeVersion);
                if (record == null) {
                    throw new EOFException();
                }
                UpdateType updateType = serde.getUpdateType(record);
                if (updateType == UpdateType.DELETE) {
                    logger.warn("While recovering from snapshot, found record with type 'DELETE'; this record will not be restored");
                    continue;
                }
                logger.trace("Recovered from snapshot: {}", record);
                this.recordMap.put(serde.getRecordIdentifier(record), record);
            }
            int numSwapRecords = dataIn.readInt();
            HashSet<String> swapLocations = new HashSet<String>();
            for (int i = 0; i < numSwapRecords; ++i) {
                swapLocations.add(dataIn.readUTF());
            }
            this.swapLocations.addAll(swapLocations);
            logger.info("{} restored {} Records and {} Swap Files from Snapshot, ending with Transaction ID {}", new Object[]{this, numRecords, swapLocations.size(), maxTransactionId});
            StandardSnapshotRecovery<T> standardSnapshotRecovery = new StandardSnapshotRecovery<T>(this.recordMap, swapLocations, snapshotFile, maxTransactionId);
            return standardSnapshotRecovery;
        }
    }

    @Override
    public void update(Collection<T> records) {
        block5: for (T record : records) {
            Object recordId = this.serdeFactory.getRecordIdentifier(record);
            UpdateType updateType = this.serdeFactory.getUpdateType(record);
            switch (updateType) {
                case DELETE: {
                    this.recordMap.remove(recordId);
                    continue block5;
                }
                case SWAP_OUT: {
                    String location = this.serdeFactory.getLocation(record);
                    if (location == null) {
                        logger.error("Received Record (ID=" + recordId + ") with UpdateType of SWAP_OUT but no indicator of where the Record is to be Swapped Out to; these records may be lost when the repository is restored!");
                        continue block5;
                    }
                    this.recordMap.remove(recordId);
                    this.swapLocations.add(location);
                    continue block5;
                }
                case SWAP_IN: {
                    String swapLocation = this.serdeFactory.getLocation(record);
                    if (swapLocation == null) {
                        logger.error("Received Record (ID=" + recordId + ") with UpdateType of SWAP_IN but no indicator of where the Record is to be Swapped In from; these records may be duplicated when the repository is restored!");
                    } else {
                        this.swapLocations.remove(swapLocation);
                    }
                    this.recordMap.put(recordId, record);
                    continue block5;
                }
            }
            this.recordMap.put(recordId, record);
        }
    }

    @Override
    public int getRecordCount() {
        return this.recordMap.size();
    }

    @Override
    public T lookup(Object recordId) {
        return (T)this.recordMap.get(recordId);
    }

    @Override
    public SnapshotCapture<T> prepareSnapshot(long maxTransactionId) {
        return new Snapshot(new HashMap<Object, T>(this.recordMap), new HashSet<String>(this.swapLocations), maxTransactionId);
    }

    private int getVersion() {
        return 1;
    }

    private File getPartialFile() {
        return new File(this.storageDirectory, "checkpoint.partial");
    }

    private File getSnapshotFile() {
        return new File(this.storageDirectory, "checkpoint");
    }

    @Override
    public synchronized void writeSnapshot(SnapshotCapture<T> snapshot) throws IOException {
        boolean rename;
        SerDe<T> serde = this.serdeFactory.createSerDe(null);
        File snapshotFile = this.getSnapshotFile();
        File partialFile = this.getPartialFile();
        if (!snapshotFile.exists() && partialFile.exists() && !(rename = partialFile.renameTo(snapshotFile))) {
            throw new IOException("Failed to rename partial snapshot file " + partialFile + " to " + snapshotFile);
        }
        try (FileOutputStream fileOut = new FileOutputStream(this.getPartialFile());
             BufferedOutputStream bufferedOut = new BufferedOutputStream(fileOut);
             DataOutputStream dataOut = new DataOutputStream(bufferedOut);){
            dataOut.writeUTF(HashMapSnapshot.class.getName());
            dataOut.writeInt(this.getVersion());
            dataOut.writeUTF(serde.getClass().getName());
            dataOut.writeInt(serde.getVersion());
            dataOut.writeLong(snapshot.getMaxTransactionId());
            dataOut.writeInt(snapshot.getRecords().size());
            serde.writeHeader(dataOut);
            for (T record : snapshot.getRecords().values()) {
                logger.trace("Checkpointing {}", record);
                serde.serializeRecord(record, dataOut);
            }
            dataOut.writeInt(snapshot.getSwapLocations().size());
            for (String swapLocation : snapshot.getSwapLocations()) {
                dataOut.writeUTF(swapLocation);
            }
            dataOut.flush();
            fileOut.getChannel().force(false);
        }
        if (snapshotFile.exists() && !snapshotFile.delete()) {
            logger.warn("Unable to delete existing Snapshot file " + snapshotFile);
        }
        if (!(rename = partialFile.renameTo(snapshotFile))) {
            throw new IOException("Failed to rename partial snapshot file " + partialFile + " to " + snapshotFile);
        }
    }

    private class SnapshotHeader {
        private final SerDe<T> serde;
        private final int serdeVersion;
        private final int numRecords;
        private final long maxTransactionId;

        public SnapshotHeader(SerDe<T> serde, int serdeVersion, long maxTransactionId, int numRecords) {
            this.serde = serde;
            this.serdeVersion = serdeVersion;
            this.maxTransactionId = maxTransactionId;
            this.numRecords = numRecords;
        }

        public SerDe<T> getSerDe() {
            return this.serde;
        }

        public int getSerDeVersion() {
            return this.serdeVersion;
        }

        public long getMaxTransactionId() {
            return this.maxTransactionId;
        }

        public int getNumRecords() {
            return this.numRecords;
        }
    }

    public class Snapshot
    implements SnapshotCapture<T> {
        private final Map<Object, T> records;
        private final long maxTransactionId;
        private final Set<String> swapLocations;

        public Snapshot(Map<Object, T> records, Set<String> swapLocations, long maxTransactionId) {
            this.records = records;
            this.swapLocations = swapLocations;
            this.maxTransactionId = maxTransactionId;
        }

        @Override
        public final Map<Object, T> getRecords() {
            return this.records;
        }

        @Override
        public long getMaxTransactionId() {
            return this.maxTransactionId;
        }

        @Override
        public Set<String> getSwapLocations() {
            return this.swapLocations;
        }
    }
}

