/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift;

import java.util.Collections;
import java.util.Map;
import shaded.parquet.org.apache.thrift.ProcessFunction;
import shaded.parquet.org.apache.thrift.TApplicationException;
import shaded.parquet.org.apache.thrift.TBase;
import shaded.parquet.org.apache.thrift.TException;
import shaded.parquet.org.apache.thrift.TProcessor;
import shaded.parquet.org.apache.thrift.protocol.TMessage;
import shaded.parquet.org.apache.thrift.protocol.TProtocol;
import shaded.parquet.org.apache.thrift.protocol.TProtocolUtil;

public abstract class TBaseProcessor<I>
implements TProcessor {
    private final I iface;
    private final Map<String, ProcessFunction<I, ? extends TBase, ? extends TBase>> processMap;

    protected TBaseProcessor(I iface, Map<String, ProcessFunction<I, ? extends TBase, ? extends TBase>> processFunctionMap) {
        this.iface = iface;
        this.processMap = processFunctionMap;
    }

    public Map<String, ProcessFunction<I, ? extends TBase, ? extends TBase>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public void process(TProtocol in, TProtocol out) throws TException {
        TMessage msg = in.readMessageBegin();
        ProcessFunction<I, TBase, TBase> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
        } else {
            fn.process(msg.seqid, in, out, this.iface);
        }
    }
}

