/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.plc4x.java.spi.codegen.io.ByteOrderAware;
import org.apache.plc4x.java.spi.codegen.withOptionByteOrder;
import org.apache.plc4x.java.spi.codegen.withOptionEncoding;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;

public interface FieldCommons {
    default public Optional<ByteOrder> extractByteOrder(WithReaderArgs ... readerArgs) {
        return this.extractByteOrder((WithReaderWriterArgs[])Stream.of(readerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public Optional<ByteOrder> extractByteOrder(WithWriterArgs ... writerArgs) {
        return this.extractByteOrder((WithReaderWriterArgs[])Stream.of(writerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public Optional<ByteOrder> extractByteOrder(WithReaderWriterArgs ... readerWriterArgs) {
        for (WithReaderWriterArgs arg : readerWriterArgs) {
            if (!(arg instanceof withOptionByteOrder)) continue;
            return Optional.of(((withOptionByteOrder)arg).byteOrder());
        }
        return Optional.empty();
    }

    default public Optional<String> extractEncoding(WithReaderArgs ... readerArgs) {
        return this.extractEncoding((WithReaderWriterArgs[])Stream.of(readerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public Optional<String> extractEncoding(WithWriterArgs ... writerArgs) {
        return this.extractEncoding((WithReaderWriterArgs[])Stream.of(writerArgs).map(WithReaderWriterArgs.class::cast).toArray(WithReaderWriterArgs[]::new));
    }

    default public Optional<String> extractEncoding(WithReaderWriterArgs ... readerWriterArgs) {
        for (WithReaderWriterArgs arg : readerWriterArgs) {
            if (!(arg instanceof withOptionEncoding)) continue;
            return Optional.of(((withOptionEncoding)arg).encoding());
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T switchParseByteOrderIfNecessary(RunParseWrapped<T> runnable, ByteOrderAware byteOrderAware, ByteOrder wantedByteOrder) throws ParseException {
        Objects.requireNonNull(runnable);
        Objects.requireNonNull(byteOrderAware);
        ByteOrder currentByteOrder = byteOrderAware.getByteOrder();
        if (wantedByteOrder == null || currentByteOrder == wantedByteOrder) {
            return runnable.run();
        }
        try {
            byteOrderAware.setByteOrder(wantedByteOrder);
            T t = runnable.run();
            return t;
        }
        finally {
            byteOrderAware.setByteOrder(currentByteOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void switchSerializeByteOrderIfNecessary(RunSerializeWrapped runnable, ByteOrderAware byteOrderAware, ByteOrder wantedByteOrder) throws SerializationException {
        Objects.requireNonNull(runnable);
        Objects.requireNonNull(byteOrderAware);
        ByteOrder currentByteOrder = byteOrderAware.getByteOrder();
        if (wantedByteOrder == null || currentByteOrder == wantedByteOrder) {
            runnable.run();
        } else {
            try {
                byteOrderAware.setByteOrder(wantedByteOrder);
                runnable.run();
            }
            finally {
                byteOrderAware.setByteOrder(currentByteOrder);
            }
        }
    }

    @FunctionalInterface
    public static interface RunParseWrapped<T> {
        public T run() throws ParseException;
    }

    @FunctionalInterface
    public static interface RunSerializeWrapped {
        public void run() throws SerializationException;
    }

    @FunctionalInterface
    public static interface ConsumeSerializeWrapped<T> {
        public void consume(T var1) throws SerializationException;
    }
}

