/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcWriter;
import org.apache.plc4x.java.spi.messages.utils.FieldValueItem;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcList;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcWriteRequest
implements PlcWriteRequest,
Serializable {
    private final PlcWriter writer;
    private final LinkedHashMap<String, FieldValueItem> fields;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcWriteRequest(@JsonProperty(value="writer") PlcWriter writer, @JsonProperty(value="fields") LinkedHashMap<String, FieldValueItem> fields) {
        this.writer = writer;
        this.fields = fields;
    }

    @JsonIgnore
    public CompletableFuture<PlcWriteResponse> execute() {
        return this.writer.write(this);
    }

    @JsonIgnore
    public int getNumberOfFields() {
        return this.fields.size();
    }

    @JsonIgnore
    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    @JsonIgnore
    public PlcField getField(String name) {
        return this.fields.get(name).getField();
    }

    @JsonIgnore
    public List<PlcField> getFields() {
        return this.fields.values().stream().map(FieldValueItem::getField).collect(Collectors.toCollection(LinkedList::new));
    }

    @JsonIgnore
    public PlcValue getPlcValue(String name) {
        return this.fields.get(name).getValue();
    }

    @JsonIgnore
    public List<PlcValue> getPlcValues() {
        return this.fields.values().stream().map(FieldValueItem::getValue).collect(Collectors.toCollection(LinkedList::new));
    }

    @JsonIgnore
    public List<Pair<String, PlcField>> getNamedFields() {
        return this.fields.entrySet().stream().map(stringPairEntry -> Pair.of((Object)((String)stringPairEntry.getKey()), (Object)((FieldValueItem)stringPairEntry.getValue()).getField())).collect(Collectors.toCollection(LinkedList::new));
    }

    public PlcWriter getWriter() {
        return this.writer;
    }

    @JsonIgnore
    public List<Triple<String, PlcField, PlcValue>> getNamedFieldTriples() {
        return this.fields.entrySet().stream().map(stringPairEntry -> Triple.of((Object)((String)stringPairEntry.getKey()), (Object)((FieldValueItem)stringPairEntry.getValue()).getField(), (Object)((FieldValueItem)stringPairEntry.getValue()).getValue())).collect(Collectors.toCollection(LinkedList::new));
    }

    @JsonIgnore
    public int getNumberOfValues(String name) {
        PlcValue value = this.fields.get(name).getValue();
        if (value instanceof PlcList) {
            PlcList list = (PlcList)value;
            return list.getLength();
        }
        return 1;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcWriteRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("fields", new WithWriterArgs[0]);
        for (Map.Entry<String, FieldValueItem> fieldEntry : this.fields.entrySet()) {
            FieldValueItem fieldValueItem = fieldEntry.getValue();
            String fieldName = fieldEntry.getKey();
            writeBuffer.pushContext(fieldName, new WithWriterArgs[0]);
            PlcField field = fieldValueItem.getField();
            if (!(field instanceof Serializable)) {
                throw new RuntimeException("Error serializing. Field doesn't implement XmlSerializable");
            }
            ((Serializable)field).serialize(writeBuffer);
            PlcValue value = fieldValueItem.getValue();
            if (value instanceof PlcList) {
                PlcList list = (PlcList)value;
                for (PlcValue plcValue : list.getList()) {
                    String plcValueString = plcValue.getString();
                    writeBuffer.writeString("value", plcValueString.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), plcValueString, new WithWriterArgs[0]);
                }
            } else {
                String plcValueString = value.getString();
                writeBuffer.writeString("value", plcValueString.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), plcValueString, new WithWriterArgs[0]);
            }
            writeBuffer.popContext(fieldName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("fields", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcWriteRequest", new WithWriterArgs[0]);
    }

    public static class Builder
    implements PlcWriteRequest.Builder {
        private final PlcWriter writer;
        private final PlcFieldHandler fieldHandler;
        private final PlcValueHandler valueHandler;
        private final Map<String, Pair<String, Object[]>> fields;

        public Builder(PlcWriter writer, PlcFieldHandler fieldHandler, PlcValueHandler valueHandler) {
            this.writer = writer;
            this.fieldHandler = fieldHandler;
            this.valueHandler = valueHandler;
            this.fields = new TreeMap<String, Pair<String, Object[]>>();
        }

        public Builder addItem(String name, String fieldQuery, Object ... values) {
            this.fields.put(name, (Pair<String, Object[]>)Pair.of((Object)fieldQuery, (Object)values));
            return this;
        }

        public PlcWriteRequest build() {
            LinkedHashMap<String, FieldValueItem> parsedFields = new LinkedHashMap<String, FieldValueItem>();
            this.fields.forEach((name, fieldValues) -> {
                String fieldQuery = (String)fieldValues.getLeft();
                PlcField field = this.fieldHandler.createField(fieldQuery);
                Object[] value = (Object[])fieldValues.getRight();
                PlcValue plcValue = this.valueHandler.newPlcValue(field, value);
                parsedFields.put((String)name, new FieldValueItem(field, plcValue));
            });
            return new DefaultPlcWriteRequest(this.writer, parsedFields);
        }
    }
}

