/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcBOOL
extends PlcIECValue<Boolean> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static int minValue = 0;
    static int maxValue = 1;

    public static PlcBOOL of(Object value) {
        if (value instanceof Boolean) {
            return new PlcBOOL((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcBOOL((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcBOOL((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcBOOL((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcBOOL((Long)value);
        }
        if (value instanceof Float) {
            return new PlcBOOL((Float)value);
        }
        if (value instanceof Double) {
            return new PlcBOOL((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcBOOL((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcBOOL((BigDecimal)value);
        }
        return new PlcBOOL((String)value);
    }

    public PlcBOOL(Boolean value) {
        this.value = value;
        this.isNullable = true;
    }

    public PlcBOOL(Byte value) {
        if (value == null || value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value >= 1;
        this.isNullable = true;
    }

    public PlcBOOL(Short value) {
        if (value == null || value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value >= 1;
        this.isNullable = true;
    }

    public PlcBOOL(Integer value) {
        if (value == null || value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format("Value of type %d is out of range %d - %d for a %s Value", value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value >= 1;
        this.isNullable = true;
    }

    public PlcBOOL(Long value) {
        if (value == null || value < (long)minValue || value > (long)maxValue) {
            throw new PlcInvalidFieldException(String.format("Value of type %d is out of range %d - %d for a %s Value", value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value >= 1L;
        this.isNullable = true;
    }

    public PlcBOOL(Float value) {
        if (value == null || value.floatValue() < (float)minValue || value.floatValue() > (float)maxValue || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.floatValue() >= 1.0f;
        this.isNullable = true;
    }

    public PlcBOOL(Double value) {
        if (value == null || value < (double)minValue || value > (double)maxValue || value % 1.0 != 0.0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value >= 1.0;
        this.isNullable = true;
    }

    public PlcBOOL(BigInteger value) {
        if (value == null || value.compareTo(BigInteger.valueOf(minValue)) < 0 || value.compareTo(BigInteger.valueOf(maxValue)) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.compareTo(BigInteger.valueOf(maxValue)) >= 0;
        this.isNullable = true;
    }

    public PlcBOOL(BigDecimal value) {
        if (value == null || value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.compareTo(BigDecimal.valueOf(maxValue)) >= 0;
        this.isNullable = true;
    }

    public PlcBOOL(String value) {
        try {
            this.value = this.parseValue(value);
            this.isNullable = false;
        }
        catch (RuntimeException e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private boolean parseValue(String value) {
        try {
            return Integer.parseInt(value.trim()) > 0;
        }
        catch (NumberFormatException ignore) {
            return Boolean.parseBoolean(value.trim());
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcBOOL(@JsonProperty(value="value") boolean value) {
        this.value = value;
        this.isNullable = true;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.BOOL;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && (Boolean)this.value != false;
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return true;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return (byte)(this.value != null && (Boolean)this.value != false ? 1 : 0);
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return true;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return (short)(this.value != null && (Boolean)this.value != false ? 1 : 0);
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return this.value != null && (Boolean)this.value != false ? 1 : 0;
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return this.value != null && (Boolean)this.value != false ? 1L : 0L;
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return (Boolean)this.value != false ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return this.value != null && (Boolean)this.value != false ? 1.0f : 0.0f;
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return this.value != null && (Boolean)this.value != false ? 1.0 : 0.0;
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return (Boolean)this.value != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public byte[] getBytes() {
        byte[] byArray;
        if (this.value != null && ((Boolean)this.value).booleanValue()) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    @JsonIgnore
    public String toString() {
        return Boolean.toString((Boolean)this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeBit(this.getClass().getSimpleName(), (Boolean)this.value, new WithWriterArgs[0]);
    }
}

