/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.streams.jackson.StreamsJacksonModule;
import org.apache.streams.pojo.StreamsJacksonMapperConfiguration;

public class StreamsJacksonMapper
extends ObjectMapper {
    private static Map<StreamsJacksonMapperConfiguration, StreamsJacksonMapper> INSTANCE_MAP = new ConcurrentHashMap<StreamsJacksonMapperConfiguration, StreamsJacksonMapper>();
    private StreamsJacksonMapperConfiguration configuration = new StreamsJacksonMapperConfiguration();

    public static StreamsJacksonMapper getInstance() {
        return StreamsJacksonMapper.getInstance(new StreamsJacksonMapperConfiguration());
    }

    public static StreamsJacksonMapper getInstance(StreamsJacksonMapperConfiguration configuration) {
        if (INSTANCE_MAP.containsKey(configuration) && INSTANCE_MAP.get(configuration) != null) {
            return INSTANCE_MAP.get(configuration);
        }
        INSTANCE_MAP.put(configuration, new StreamsJacksonMapper(configuration));
        return INSTANCE_MAP.get(configuration);
    }

    @Deprecated
    public static StreamsJacksonMapper getInstance(String format) {
        return new StreamsJacksonMapper(Collections.singletonList(format));
    }

    @Deprecated
    public static StreamsJacksonMapper getInstance(List<String> formats) {
        return new StreamsJacksonMapper(formats);
    }

    protected StreamsJacksonMapper() {
        this.registerModule((Module)new StreamsJacksonModule(this.configuration.getDateFormats()));
        if (this.configuration.getEnableScala().booleanValue()) {
            this.registerModule((Module)new DefaultScalaModule());
        }
        this.configure();
    }

    @Deprecated
    public StreamsJacksonMapper(String format) {
        this.registerModule((Module)new StreamsJacksonModule(Collections.singletonList(format)));
        if (this.configuration.getEnableScala().booleanValue()) {
            this.registerModule((Module)new DefaultScalaModule());
        }
        this.configure();
    }

    @Deprecated
    public StreamsJacksonMapper(List<String> formats) {
        this.registerModule((Module)new StreamsJacksonModule(formats));
        if (this.configuration.getEnableScala().booleanValue()) {
            this.registerModule((Module)new DefaultScalaModule());
        }
        this.configure();
    }

    public StreamsJacksonMapper(StreamsJacksonMapperConfiguration configuration) {
        this.registerModule((Module)new StreamsJacksonModule(configuration.getDateFormats()));
        if (configuration.getEnableScala().booleanValue()) {
            this.registerModule((Module)new DefaultScalaModule());
        }
        this.configure();
    }

    public void configure() {
        this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE);
        this.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, Boolean.TRUE);
        this.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE);
        this.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE);
        this.configure(DeserializationFeature.WRAP_EXCEPTIONS, Boolean.FALSE);
        this.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, Boolean.TRUE);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, Boolean.FALSE);
        this.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, Boolean.FALSE);
        this.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, Boolean.FALSE);
        this.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.DEFAULT);
        this.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

