/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.juneau;

import org.apache.commons.lang3.StringUtils;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.StringSwap;
import org.apache.streams.data.util.RFC3339Utils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaDateSwap
extends StringSwap<DateTime> {
    DateTimeFormatter dateFormatter = ISODateTimeFormat.dateTime();

    public String swap(BeanSession session, DateTime o) {
        DateTimeFormatter dateFormatter = this.dateFormatter;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)session.getProperty("format", String.class, (Object)RFC3339Utils.UTC_STANDARD_FMT.toString())))) {
            dateFormatter = DateTimeFormat.forPattern((String)((String)session.getProperty("format", String.class, (Object)RFC3339Utils.UTC_STANDARD_FMT.toString())));
        }
        return dateFormatter.print((ReadableInstant)o);
    }

    public DateTime unswap(BeanSession session, String f, ClassMeta<?> hint) throws ParseException {
        DateTimeFormatter dateFormatter = this.dateFormatter;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)session.getProperty("format", String.class, (Object)RFC3339Utils.UTC_STANDARD_FMT.toString())))) {
            dateFormatter = DateTimeFormat.forPattern((String)((String)session.getProperty("format", String.class, (Object)RFC3339Utils.UTC_STANDARD_FMT.toString())));
        }
        return dateFormatter.parseDateTime(f);
    }
}

