/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import http.utils.multipartrequest.MultipartRequest;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

public class PellMultiPartRequest
implements MultiPartRequest {
    private static final Logger LOG = LogManager.getLogger(PellMultiPartRequest.class);
    private ServletMultipartRequest multi;
    private String defaultEncoding;
    private boolean maxSizeProvided;
    private int maxSize;

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String enc) {
        this.defaultEncoding = enc;
    }

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSizeProvided = true;
        this.maxSize = Integer.parseInt(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(HttpServletRequest servletRequest, String saveDir) throws IOException {
        PellMultiPartRequest pellMultiPartRequest = this;
        synchronized (pellMultiPartRequest) {
            this.setEncoding();
            this.multi = this.maxSizeProvided ? new ServletMultipartRequest(servletRequest, saveDir, this.maxSize) : new ServletMultipartRequest(servletRequest, saveDir);
        }
    }

    public Enumeration getFileParameterNames() {
        return this.multi.getFileParameterNames();
    }

    public String[] getContentType(String fieldName) {
        return new String[]{this.multi.getContentType(fieldName)};
    }

    public File[] getFile(String fieldName) {
        return new File[]{this.multi.getFile(fieldName)};
    }

    public String[] getFileNames(String fieldName) {
        return new String[]{this.multi.getFile(fieldName).getName()};
    }

    public String[] getFilesystemName(String fieldName) {
        return new String[]{this.multi.getFileSystemName(fieldName)};
    }

    public String getParameter(String name) {
        return this.multi.getURLParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.multi.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        Enumeration enumeration = this.multi.getURLParameters(name);
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            values.add((String)enumeration.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private void setEncoding() {
        String encoding = null;
        try {
            encoding = this.defaultEncoding;
            if (encoding != null) {
                MultipartRequest.setEncoding((String)encoding);
            } else {
                MultipartRequest.setEncoding((String)"UTF-8");
            }
        }
        catch (IllegalArgumentException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Could not get encoding property 'struts.i18n.encoding' for file upload.  Using system default");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding " + encoding + " is not a valid encoding.  Please check your struts.properties file.");
        }
    }

    public void cleanUp() {
        Enumeration fileParameterNames = this.multi.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            File[] files;
            String inputValue = (String)fileParameterNames.nextElement();
            for (File currentFile : files = this.getFile(inputValue)) {
                if (LOG.isInfoEnabled()) {
                    String msg = LocalizedTextUtil.findText(this.getClass(), (String)"struts.messages.removing.file", (Locale)Locale.ENGLISH, (String)"no.message.found", (Object[])new Object[]{inputValue, currentFile});
                    LOG.info(msg);
                }
                if (currentFile == null || !currentFile.isFile() || currentFile.delete()) continue;
                LOG.warn("Resource Leaking: Could not remove uploaded file [{}]", new Object[]{currentFile.getAbsolutePath()});
            }
        }
    }
}

