/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;

public class HTTPServiceListenerServlet
implements Servlet {
    private static final QName AUTEHTICATION_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "authentication");
    private transient Binding binding;
    private transient ServletConfig config;
    private transient MessageFactory messageFactory;
    private transient Invoker serviceInvoker;
    private transient boolean requiresAuthentication = false;
    private transient BasicAuthenticationPolicy basicAuthenticationPolicy = null;

    public HTTPServiceListenerServlet(Binding binding, Invoker serviceInvoker, MessageFactory messageFactory) {
        this.binding = binding;
        this.serviceInvoker = serviceInvoker;
        this.messageFactory = messageFactory;
        if (binding instanceof PolicySetAttachPoint) {
            List intents = ((PolicySetAttachPoint)binding).getRequiredIntents();
            for (Intent intent : intents) {
                if (!intent.getName().equals(AUTEHTICATION_INTENT)) continue;
                this.requiresAuthentication = true;
            }
            List policySets = ((PolicySetAttachPoint)binding).getApplicablePolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (!BasicAuthenticationPolicy.class.isInstance(p)) continue;
                    this.basicAuthenticationPolicy = (BasicAuthenticationPolicy)p;
                }
            }
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "";
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.requiresAuthentication && !this.hasAuthenticationHeader((HttpServletRequest)request, (ServletResponse)((HttpServletResponse)response))) {
            ((HttpServletResponse)response).sendError(401);
        }
        Message requestMessage = this.messageFactory.createMessage();
        requestMessage.setBody((Object)new Object[]{request, response});
        Message responseMessage = this.serviceInvoker.invoke(requestMessage);
        if (responseMessage.isFault()) {
            Throwable e = (Throwable)responseMessage.getBody();
            ((HttpServletResponse)response).sendError(500, e.toString());
        }
    }

    private boolean hasAuthenticationHeader(HttpServletRequest request, ServletResponse response) {
        boolean result = false;
        if (request.getHeader("Authorization") != null) {
            result = true;
        }
        return result;
    }
}

