/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.operationselector.provider;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class HTTPDefaultServiceOperationSelectorInterceptor
implements Interceptor {
    private Invoker next;
    private List<Operation> operations;

    public HTTPDefaultServiceOperationSelectorInterceptor(RuntimeEndpoint endpoint) {
        Interface serviceInterface = endpoint.getService().getInterfaceContract().getInterface();
        this.operations = serviceInterface.getOperations();
    }

    public Message invoke(Message msg) {
        HTTPContext context = (HTTPContext)msg.getBindingContext();
        HttpServletRequest request = context.getHttpRequest();
        Operation operation = this.findOperation(request.getMethod());
        if (operation == null) {
            operation = this.findOperation("service");
        }
        if (operation == null) {
            throw new ServiceRuntimeException("No matching operation for " + request.getMethod());
        }
        msg.setOperation(operation);
        return this.next.invoke(msg);
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Invoker getNext() {
        return this.next;
    }

    private Operation findOperation(String method) {
        if (method.contains(".")) {
            method = method.substring(method.lastIndexOf(".") + 1);
        }
        Operation result = null;
        for (Operation o : this.operations) {
            if (o.isDynamic()) {
                return o;
            }
            if (!o.getName().equalsIgnoreCase(method)) continue;
            result = o;
            break;
        }
        return result;
    }
}

